/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.actions.ActionMessages;
import org.asnlab.asndt.internal.ui.actions.ActionUtil;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.WorkingCopyManager;
import org.asnlab.asndt.internal.ui.util.ElementValidator;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class CleanUpAction
extends SelectionDispatchAction {
    private AsnEditor fEditor;

    public CleanUpAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.CleanUpAction_label);
        this.setToolTipText(ActionMessages.CleanUpAction_tooltip);
        this.setDescription(ActionMessages.CleanUpAction_description);
    }

    public CleanUpAction(AsnEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(CleanUpAction.getCompilationUnit(this.fEditor) != null);
    }

    @Override
    public void run(ITextSelection selection) {
        ICompilationUnit cu = CleanUpAction.getCompilationUnit(this.fEditor);
        if (cu != null) {
            this.run(cu);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        ICompilationUnit[] cus = this.getCompilationUnits(selection);
        if (cus.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.CleanUpAction_EmptySelection_title, (String)ActionMessages.CleanUpAction_EmptySelection_description);
        } else if (cus.length == 1) {
            this.run(cus[0]);
        } else {
            this.runOnMultiple(cus);
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(CleanUpAction.getCompilationUnit(this.fEditor) != null);
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            IAsnElement elem;
            if (selected[i] instanceof IAsnElement && (elem = (IAsnElement)selected[i]).exists()) {
                switch (elem.getElementType()) {
                    case 10: {
                        return elem.getParent().getElementType() == 5;
                    }
                    case 5: {
                        return true;
                    }
                    case 18: {
                        return true;
                    }
                    case 2: 
                    case 4: {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public void run(ICompilationUnit cu) {
        if (!ElementValidator.check((IAsnElement)cu, this.getShell(), ActionMessages.CleanUpAction_ErrorDialogTitle, this.fEditor != null)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
    }

    public void runOnMultiple(ICompilationUnit[] cus) {
        String message = ActionMessages.CleanUpAction_MultiStateErrorTitle;
        MultiStatus status = new MultiStatus("org.asnlab.asndt.ui", 0, message, null);
        int i = 0;
        while (i < cus.length) {
            this.testOnBuildPath(cus[i], status);
            ++i;
        }
        if (!status.isOK()) {
            String title = ActionMessages.CleanUpAction_ErrorDialogTitle;
            ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
            return;
        }
    }

    private void showUnexpectedError(CoreException e) {
        String message2 = Messages.format(ActionMessages.CleanUpAction_UnexpectedErrorMessage, e.getStatus().getMessage());
        Status status = new Status(4, "org.asnlab.asndt.ui", 4, message2, null);
        String title = ActionMessages.CleanUpAction_ErrorDialogTitle;
        ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
    }

    private boolean testOnBuildPath(ICompilationUnit cu, MultiStatus status) {
        IAsnProject project = cu.getAsnProject();
        if (!project.isOnBuildPath((IAsnElement)cu)) {
            String cuLocation = cu.getPath().makeRelative().toString();
            String message = Messages.format(ActionMessages.CleanUpAction_CUNotOnBuildpathMessage, cuLocation);
            status.add((IStatus)new Status(1, "org.asnlab.asndt.ui", 4, message, null));
            return false;
        }
        return true;
    }

    private ICompilationUnit[] getCompilationUnits(IStructuredSelection selection) {
        HashSet<IAsnElement> result = new HashSet<IAsnElement>();
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block12: {
                try {
                    IAsnElement elem;
                    if (!(selected[i] instanceof IAsnElement) || !(elem = (IAsnElement)selected[i]).exists()) break block12;
                    switch (elem.getElementType()) {
                        case 10: {
                            if (elem.getParent().getElementType() == 5) {
                                result.add(elem.getParent());
                            }
                            break;
                        }
                        case 5: {
                            result.add(elem);
                            break;
                        }
                        case 18: {
                            result.add(elem.getParent());
                            break;
                        }
                        case 4: {
                            this.collectCompilationUnits((ISourceFolder)elem, result);
                            break;
                        }
                        case 2: {
                            ISourceFolder[] roots = ((IAsnProject)elem).getSourceFolders();
                            int k = 0;
                            while (k < roots.length) {
                                this.collectCompilationUnits(roots[k], result);
                                ++k;
                            }
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (AsnModelException e) {
                    if (!AsnModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block12;
                    AsnPlugin.log(e);
                }
            }
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private void collectCompilationUnits(ISourceFolder pack, Collection result) throws AsnModelException {
        result.addAll(Arrays.asList(pack.getCompilationUnits()));
    }

    private static ICompilationUnit getCompilationUnit(AsnEditor editor) {
        WorkingCopyManager manager = AsnPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit cu = manager.getWorkingCopy(editor.getEditorInput());
        return cu;
    }
}

