/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import java.util.List;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.ASTParser;
import org.asnlab.asndt.core.dom.ASTVisitor;
import org.asnlab.asndt.core.dom.CompilationUnitDeclaration;
import org.asnlab.asndt.core.dom.DefaultASTVisitor;
import org.asnlab.asndt.core.dom.ModuleDefinition;
import org.asnlab.asndt.internal.core.CompilationUnit;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ASTProvider {
    public static final WAIT_FLAG WAIT_YES = new WAIT_FLAG("wait yes");
    public static final WAIT_FLAG WAIT_ACTIVE_ONLY = new WAIT_FLAG("wait active only");
    public static final WAIT_FLAG WAIT_NO = new WAIT_FLAG("don't wait");
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.asnlab.asndt.ui/debug/ASTProvider"));
    private static final String DEBUG_PREFIX = "ASTProvider > ";
    private IAsnElement fReconcilingAsnElement;
    private IAsnElement fActiveAsnElement;
    private CompilationUnitDeclaration fAST;
    private ActivationListener fActivationListener;
    private Object fReconcileLock = new Object();
    private Object fWaitLock = new Object();
    private boolean fIsReconciling;
    private IWorkbenchPart fActiveEditor;

    public static ASTProvider getASTProvider() {
        return AsnPlugin.getDefault().getASTProvider();
    }

    public ASTProvider() {
        this.install();
    }

    void install() {
        this.fActivationListener = new ActivationListener();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().addPartListener((IPartListener2)this.fActivationListener);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeAsnEditorChanged(IWorkbenchPart editor) {
        IAsnElement asnElement = null;
        if (editor instanceof AsnEditor) {
            asnElement = ((AsnEditor)editor).getInputAsnElement();
        }
        Object object = this;
        synchronized (object) {
            this.fActiveEditor = editor;
            this.fActiveAsnElement = asnElement;
            this.cache(null, asnElement);
        }
        if (DEBUG) {
            System.out.println(this.getThreadName() + " - ASTProvider > active editor is: " + this.toString(asnElement));
        }
        object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling && (this.fReconcilingAsnElement == null || !this.fReconcilingAsnElement.equals(asnElement))) {
                this.fIsReconciling = false;
                this.fReconcilingAsnElement = null;
            } else if (asnElement == null) {
                this.fIsReconciling = false;
                this.fReconcilingAsnElement = null;
            }
        }
    }

    public boolean isCached(CompilationUnitDeclaration ast) {
        return ast != null && this.fAST == ast;
    }

    public boolean isActive(ICompilationUnit cu) {
        return cu != null && cu.equals(this.fActiveAsnElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aboutToBeReconciled(IAsnElement asnElement) {
        if (asnElement == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(this.getThreadName() + " - ASTProvider > about to reconcile: " + this.toString(asnElement));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = true;
            this.fReconcilingAsnElement = asnElement;
        }
        this.cache(null, asnElement);
    }

    private synchronized void disposeAST() {
        if (this.fAST == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(this.getThreadName() + " - ASTProvider > disposing AST: " + this.toString(this.fAST) + " for: " + this.toString(this.fActiveAsnElement));
        }
        this.fAST = null;
        this.cache(null, null);
    }

    private String toString(IAsnElement asnElement) {
        if (asnElement == null) {
            return "null";
        }
        return asnElement.getElementName();
    }

    private String toString(CompilationUnitDeclaration ast) {
        if (ast == null) {
            return "null";
        }
        List modules = ast.moduleDefinitions();
        if (modules != null && modules.size() > 0) {
            return ((ModuleDefinition)modules.get(0)).getName().getIdentifier();
        }
        return "AST without any module";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cache(CompilationUnitDeclaration ast, IAsnElement asnElement) {
        if (this.fActiveAsnElement != null && !this.fActiveAsnElement.equals(asnElement)) {
            if (DEBUG && asnElement != null) {
                System.out.println(this.getThreadName() + " - ASTProvider > don't cache AST for inactive: " + this.toString(asnElement));
            }
            return;
        }
        if (DEBUG && (asnElement != null || ast != null)) {
            System.out.println(this.getThreadName() + " - ASTProvider > caching AST: " + this.toString(ast) + " for: " + this.toString(asnElement));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = ast;
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompilationUnitDeclaration getAST(IAsnElement ae, WAIT_FLAG waitFlag, IProgressMonitor progressMonitor) {
        boolean isActiveElement;
        if (ae == null) {
            return null;
        }
        Assert.isTrue((ae.getElementType() == 5 ? 1 : 0) != 0);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            isActiveElement = ae.equals(this.fActiveAsnElement);
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (!DEBUG) return this.fAST;
                    System.out.println(this.getThreadName() + " - ASTProvider > returning cached AST:" + this.toString(this.fAST) + " for: " + ae.getElementName());
                    return this.fAST;
                }
                if (waitFlag == WAIT_NO) {
                    if (!DEBUG) return null;
                    System.out.println(this.getThreadName() + " - ASTProvider > returning null (WAIT_NO) for: " + ae.getElementName());
                    return null;
                }
            }
        }
        if (isActiveElement && this.isReconciling(ae)) {
            try {
                IAsnElement activeElement = this.fReconcilingAsnElement;
                Object object = this.fWaitLock;
                synchronized (object) {
                    if (DEBUG) {
                        System.out.println(this.getThreadName() + " - ASTProvider > waiting for AST for: " + ae.getElementName());
                    }
                    this.fWaitLock.wait();
                }
                object = this;
                synchronized (object) {
                    if (activeElement != this.fActiveAsnElement) return this.getAST(ae, waitFlag, progressMonitor);
                    if (this.fAST == null) return this.getAST(ae, waitFlag, progressMonitor);
                    if (!DEBUG) return this.fAST;
                    System.out.println(this.getThreadName() + " - ASTProvider > ...got AST for: " + ae.getElementName());
                    return this.fAST;
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        if (waitFlag == WAIT_NO) return null;
        if (waitFlag == WAIT_ACTIVE_ONLY) {
            if (!isActiveElement) return null;
            if (this.fAST != null) {
                return null;
            }
        }
        if (isActiveElement) {
            this.aboutToBeReconciled(ae);
        }
        CompilationUnitDeclaration ast = null;
        try {
            ast = this.createAST(ae, progressMonitor);
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                ast = null;
                return ast;
            }
            if (!DEBUG) return ast;
            if (ast == null) return ast;
            System.err.println(this.getThreadName() + " - ASTProvider > created AST for: " + ae.getElementName());
            return ast;
        }
        finally {
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (DEBUG) {
                        System.out.println(this.getThreadName() + " - ASTProvider > Ignore created AST for " + ae.getElementName() + "- AST from reconciler is newer");
                    }
                    this.reconciled(this.fAST, ae, null);
                } else {
                    this.reconciled(ast, ae, null);
                }
            }
        }
    }

    public CompilationUnitDeclaration getAST(IAsnElement je, boolean wait, IProgressMonitor progressMonitor) {
        if (wait) {
            return this.getAST(je, WAIT_YES, progressMonitor);
        }
        return this.getAST(je, WAIT_NO, progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReconciling(IAsnElement asnElement) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            return asnElement != null && asnElement.equals(this.fReconcilingAsnElement) && this.fIsReconciling;
        }
    }

    private CompilationUnitDeclaration createAST(IAsnElement ae, final IProgressMonitor progressMonitor) {
        if (!this.hasSource(ae) || !(ae instanceof CompilationUnit)) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        CompilationUnit compilationUnit = (CompilationUnit)ae;
        final ASTParser parser = ASTParser.newParser((CompilationUnit)compilationUnit, null);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        try {
            parser.setSource(compilationUnit.getSource().toCharArray());
        }
        catch (AsnModelException e) {
            e.printStackTrace();
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final CompilationUnitDeclaration[] root = new CompilationUnitDeclaration[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        root[0] = null;
                    }
                    root[0] = (CompilationUnitDeclaration)parser.parse(progressMonitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    root[0] = null;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.asnlab.asndt.ui", 0, "Error in ASNDT Core during AST creation", ex);
                AsnPlugin.getDefault().getLog().log((IStatus)status);
            }
        });
        if (root[0] != null) {
            ASTProvider.setFlagsToAST((ASTNode)root[0], 4);
        }
        return root[0];
    }

    public static void setFlagsToAST(ASTNode root, final int flags) {
        root.accept((ASTVisitor)new DefaultASTVisitor(){

            protected boolean visitNode(ASTNode node) {
                node.setFlags(node.getFlags() | flags);
                return true;
            }
        });
    }

    private boolean hasSource(IAsnElement je) {
        if (je == null || !je.exists()) {
            return false;
        }
        try {
            return je instanceof ISourceReference && ((ISourceReference)je).getSource() != null;
        }
        catch (AsnModelException ex) {
            Status status = new Status(4, "org.asnlab.asndt.ui", 0, "Error in ASNDT Core during AST creation", (Throwable)ex);
            AsnPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
        this.fActivationListener = null;
        this.disposeAST();
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconciled(CompilationUnitDeclaration ast, IAsnElement asnElement, IProgressMonitor progressMonitor) {
        if (DEBUG) {
            System.out.println(this.getThreadName() + " - ASTProvider > reconciled: " + this.toString(asnElement) + ", AST: " + this.toString(ast));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            boolean bl = this.fIsReconciling = progressMonitor != null && progressMonitor.isCanceled();
            if (asnElement == null || !asnElement.equals(this.fReconcilingAsnElement)) {
                if (DEBUG) {
                    System.out.println(this.getThreadName() + " - ASTProvider >   ignoring AST of out-dated editor");
                }
                Object object2 = this.fWaitLock;
                synchronized (object2) {
                    this.fWaitLock.notifyAll();
                }
                return;
            }
            this.cache(ast, asnElement);
        }
    }

    private String getThreadName() {
        String name = Thread.currentThread().getName();
        if (name != null) {
            return name;
        }
        return Thread.currentThread().toString();
    }

    private class ActivationListener
    implements IPartListener2,
    IWindowListener {
        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (this.isAsnEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeAsnEditorChanged(ref.getPart(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            if (this.isAsnEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeAsnEditorChanged(ref.getPart(true));
            }
        }

        public void partClosed(IWorkbenchPartReference ref) {
            if (this.isActiveEditor(ref)) {
                if (DEBUG) {
                    System.out.println(ASTProvider.this.getThreadName() + " - ASTProvider > closed active editor: " + ref.getTitle());
                }
                ASTProvider.this.activeAsnEditorChanged(null);
            }
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
            if (this.isAsnEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeAsnEditorChanged(ref.getPart(true));
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (this.isAsnEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeAsnEditorChanged(ref.getPart(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (this.isAsnEditor(ref) && this.isActiveEditor(ref)) {
                ASTProvider.this.activeAsnEditorChanged(ref.getPart(true));
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPartReference ref = window.getPartService().getActivePartReference();
            if (this.isAsnEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeAsnEditorChanged(ref.getPart(true));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (ASTProvider.this.fActiveEditor != null && ASTProvider.this.fActiveEditor.getSite() != null && window == ASTProvider.this.fActiveEditor.getSite().getWorkbenchWindow()) {
                if (DEBUG) {
                    System.out.println(ASTProvider.this.getThreadName() + " - ASTProvider > closed active editor: " + ASTProvider.this.fActiveEditor.getTitle());
                }
                ASTProvider.this.activeAsnEditorChanged(null);
            }
            window.getPartService().removePartListener((IPartListener2)this);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener2)this);
        }

        private boolean isActiveEditor(IWorkbenchPartReference ref) {
            return ref != null && this.isActiveEditor(ref.getPart(false));
        }

        private boolean isActiveEditor(IWorkbenchPart part) {
            return part != null && part == ASTProvider.this.fActiveEditor;
        }

        private boolean isAsnEditor(IWorkbenchPartReference ref) {
            if (ref == null) {
                return false;
            }
            String id = ref.getId();
            return "org.asnlab.asndt.ui.ClassFileEditor".equals(id) || "org.asnlab.asndt.ui.CompilationUnitEditor".equals(id) || ref.getPart(false) instanceof AsnEditor;
        }
    }

    public static final class WAIT_FLAG {
        String fName;

        private WAIT_FLAG(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }
    }
}

