/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.model;

import org.asnlab.asndt.internal.ui.AsnPluginImages;
import org.asnlab.asndt.internal.ui.model.ModelMessages;
import org.asnlab.asndt.internal.ui.viewsupport.AsnUILabelProvider;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryLabelProvider;
import org.eclipse.swt.graphics.Image;

public final class AsnModelLabelProvider
extends AsnUILabelProvider {
    private static final String NAME_SETTINGS_FOLDER = ".settings";
    private final RefactoringHistoryLabelProvider fHistoryLabelProvider = new RefactoringHistoryLabelProvider(new RefactoringHistoryControlConfiguration(null, false, false));
    private final String fPreferencesLabel;
    private final String fRefactoringsLabel;
    private Image fSettingsImage = null;

    public AsnModelLabelProvider() {
        this(ModelMessages.AsnModelLabelProvider_project_preferences_label, ModelMessages.AsnModelLabelProvider_refactorings_label);
    }

    public AsnModelLabelProvider(String preferences, String refactorings) {
        Assert.isNotNull((Object)preferences);
        Assert.isNotNull((Object)refactorings);
        this.fPreferencesLabel = preferences;
        this.fRefactoringsLabel = refactorings;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fHistoryLabelProvider.dispose();
        if (this.fSettingsImage != null && !this.fSettingsImage.isDisposed()) {
            this.fSettingsImage.dispose();
            this.fSettingsImage = null;
        }
    }

    @Override
    public Image getImage(Object element) {
        IFolder folder;
        if (element instanceof IFolder && (folder = (IFolder)element).getName().equals(NAME_SETTINGS_FOLDER)) {
            if (this.fSettingsImage == null || this.fSettingsImage.isDisposed()) {
                this.fSettingsImage = AsnPluginImages.DESC_OBJS_PROJECT_SETTINGS.createImage();
            }
            return this.decorateImage(this.fSettingsImage, element);
        }
        Image image = super.getImage(element);
        if (image == null) {
            if (element instanceof RefactoringHistory) {
                image = this.fHistoryLabelProvider.getImage(element);
            } else if (element instanceof RefactoringDescriptorProxy) {
                image = this.fHistoryLabelProvider.getImage(element);
            }
            return this.decorateImage(image, element);
        }
        return image;
    }

    @Override
    public String getText(Object element) {
        IFolder folder;
        if (element instanceof IFolder && (folder = (IFolder)element).getName().equals(NAME_SETTINGS_FOLDER)) {
            return this.decorateText(this.fPreferencesLabel, element);
        }
        String text = super.getText(element);
        if (text == null || "".equals(text)) {
            if (element instanceof RefactoringHistory) {
                text = this.fRefactoringsLabel;
            } else if (element instanceof RefactoringDescriptorProxy) {
                text = this.fHistoryLabelProvider.getText(element);
            }
            return this.decorateText(text, element);
        }
        return text;
    }
}

