/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.internal.corext.util.AsnElementResourceMapping;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.model.AsnModelContentProvider;
import org.asnlab.asndt.internal.ui.model.AsnModelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.model.AbstractSynchronizationContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public final class AsnSynchronizationContentProvider
extends AbstractSynchronizationContentProvider
implements IPipelinedTreeContentProvider {
    private ITreeContentProvider fContentProvider = null;
    private Object fModelRoot = null;

    static IDiff[] getDiffs(ISynchronizationContext context, Object element) {
        return context.getDiffTree().getDiffs(AsnSynchronizationContentProvider.getResourceTraversals(element));
    }

    static ResourceMapping getResourceMapping(Object element) {
        IAdaptable adaptable;
        Object adapted;
        if (element instanceof IAsnElement) {
            return AsnElementResourceMapping.create((IAsnElement)element);
        }
        if (element instanceof IAdaptable && (adapted = (adaptable = (IAdaptable)element).getAdapter(ResourceMapping.class)) instanceof ResourceMapping) {
            return (ResourceMapping)adapted;
        }
        return null;
    }

    static ResourceTraversal[] getResourceTraversals(Object element) {
        ResourceMapping mapping = AsnSynchronizationContentProvider.getResourceMapping(element);
        if (mapping != null) {
            try {
                return mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                AsnPlugin.log(exception);
            }
        }
        return new ResourceTraversal[0];
    }

    private IAsnProject asAsnProject(IProject project) {
        block3: {
            try {
                if (project.getDescription().hasNature("org.asnlab.asndt.core.asnnature")) {
                    return AsnCore.create((IProject)project);
                }
            }
            catch (CoreException exception) {
                if (!project.isAccessible()) break block3;
                AsnPlugin.log(exception);
            }
        }
        return null;
    }

    private void convertToAsnElements(PipelinedShapeModification modification) {
        IAsnProject project;
        Object parent = modification.getParent();
        if (parent instanceof IResource && (project = this.asAsnProject(((IResource)parent).getProject())) != null) {
            modification.getChildren().clear();
            return;
        }
        if (parent instanceof ISynchronizationContext) {
            HashSet<IAsnProject> result = new HashSet<IAsnProject>();
            Iterator iterator = modification.getChildren().iterator();
            while (iterator.hasNext()) {
                IAsnProject project2;
                Object element = iterator.next();
                if (!(element instanceof IProject) || (project2 = this.asAsnProject((IProject)element)) == null) continue;
                iterator.remove();
                result.add(project2);
            }
            modification.getChildren().addAll(result);
        }
    }

    private boolean convertToAsnElements(PipelinedViewerUpdate update) {
        HashSet<IAsnProject> result = new HashSet<IAsnProject>();
        Iterator iterator = update.getRefreshTargets().iterator();
        while (iterator.hasNext()) {
            IAsnProject project;
            Object element = iterator.next();
            if (!(element instanceof IProject) || (project = this.asAsnProject((IProject)element)) == null) continue;
            iterator.remove();
            result.add(project);
        }
        update.getRefreshTargets().addAll(result);
        return !result.isEmpty();
    }

    public void diffsChanged(final IDiffChangeEvent event, IProgressMonitor monitor) {
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                AsnSynchronizationContentProvider.this.handleChange(event);
            }
        }, this.getViewer().getControl());
    }

    private IAsnProject[] getChangedProjects(IDiffChangeEvent event) {
        HashSet<IAsnProject> result = new HashSet<IAsnProject>();
        IDiff[] changes = event.getChanges();
        int index = 0;
        while (index < changes.length) {
            IAsnProject project;
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)changes[index]);
            if (resource != null && (project = this.asAsnProject(resource.getProject())) != null) {
                result.add(project);
            }
            ++index;
        }
        IDiff[] additions = event.getAdditions();
        int index2 = 0;
        while (index2 < additions.length) {
            IAsnProject project;
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)additions[index2]);
            if (resource != null && (project = this.asAsnProject(resource.getProject())) != null) {
                result.add(project);
            }
            ++index2;
        }
        IPath[] removals = event.getRemovals();
        int i = 0;
        while (i < removals.length) {
            IAsnProject asnProject;
            IProject project;
            IPath path = removals[i];
            if (path.segmentCount() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))).exists() && (asnProject = this.asAsnProject(project.getProject())) != null) {
                result.add(asnProject);
            }
            ++i;
        }
        return result.toArray(new IAsnProject[result.size()]);
    }

    protected Object[] getChildrenInContext(ISynchronizationContext context, Object parent, Object[] children) {
        Object[] elements = super.getChildrenInContext(context, parent, children);
        if (parent instanceof ISourceFolder) {
            return this.getPackageFragmentChildren(context, parent, elements);
        }
        if (parent instanceof IAsnProject) {
            return this.getAsnProjectChildren(context, parent, elements);
        }
        if (parent instanceof RefactoringHistory) {
            return ((RefactoringHistory)parent).getDescriptors();
        }
        return this.getFilteredElements(parent, elements);
    }

    private Object[] getFilteredElements(Object parent, Object[] children) {
        ArrayList<Object> result = new ArrayList<Object>(children.length);
        int index = 0;
        while (index < children.length) {
            if (children[index] instanceof IFolder) {
                if (!(AsnCore.create((IFolder)((IFolder)children[index])) instanceof ISourceFolder)) {
                    result.add(children[index]);
                }
            } else {
                result.add(children[index]);
            }
            ++index;
        }
        return result.toArray();
    }

    protected ITreeContentProvider getDelegateContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new AsnModelContentProvider();
        }
        return this.fContentProvider;
    }

    private Set getDeletedProjects(IDiffChangeEvent event) {
        HashSet<IProject> result = new HashSet<IProject>();
        IPath[] deletions = event.getRemovals();
        int index = 0;
        while (index < deletions.length) {
            IProject project;
            IPath path = deletions[index];
            if (path.segmentCount() > 0 && !(project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))).isAccessible()) {
                result.add(project);
            }
            ++index;
        }
        return result;
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            parent = this.getModelRoot();
        }
        return super.getElements(parent);
    }

    private Object[] getAsnProjectChildren(ISynchronizationContext context, Object parent, Object[] children) {
        LinkedList<Object> list = new LinkedList<Object>();
        int index = 0;
        while (index < children.length) {
            IFolder folder;
            ISourceFolder fragment;
            if (!(children[index] instanceof ISourceFolder && this.getChildren(fragment = (ISourceFolder)children[index]).length == 0 || children[index] instanceof IFolder && this.getChildren(folder = (IFolder)children[index]).length == 0)) {
                list.add(children[index]);
            }
            ++index;
        }
        IResource resource = AsnModelProvider.getResource(parent);
        if (resource != null) {
            IResourceDiffTree tree = context.getDiffTree();
            IResource[] members = tree.members(resource);
            int index2 = 0;
            while (index2 < members.length) {
                IResource child = members[index2];
                if (this.isVisible(context, child) && this.hasPhantomFolder(tree, child)) {
                    list.add(child);
                }
                ++index2;
            }
        }
        return list.toArray(new Object[list.size()]);
    }

    private boolean hasPhantomFolder(IResourceDiffTree tree, IResource child) {
        if (!child.exists()) {
            return true;
        }
        final boolean[] found = new boolean[1];
        tree.accept(child.getFullPath(), new IDiffVisitor(){

            public boolean visit(IDiff delta) {
                IResource treeResource = ResourceDiffTree.getResourceFor((IDiff)delta);
                if (treeResource.getType() == 1 && !treeResource.getParent().exists()) {
                    found[0] = true;
                    return false;
                }
                return true;
            }
        }, 2);
        return found[0];
    }

    protected String getModelProviderId() {
        return "org.asnlab.asndt.ui.modelProvider";
    }

    protected Object getModelRoot() {
        if (this.fModelRoot == null) {
            this.fModelRoot = AsnCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        }
        return this.fModelRoot;
    }

    private Object[] getPackageFragmentChildren(ISynchronizationContext context, Object parent, Object[] children) {
        HashSet<Object> set = new HashSet<Object>();
        int index = 0;
        while (index < children.length) {
            set.add(children[index]);
            ++index;
        }
        IResource resource = ((ISourceFolder)parent).getResource();
        if (resource != null) {
            IResourceDiffTree tree = context.getDiffTree();
            IResource[] members = tree.members(resource);
            int index2 = 0;
            while (index2 < members.length) {
                IDiff diff;
                int type = members[index2].getType();
                if (type == 1 && (diff = tree.getDiff(members[index2])) != null && this.isVisible(diff) && this.isInScope(context.getScope(), parent, members[index2])) {
                    IAsnElement element = AsnCore.create((IResource)members[index2]);
                    if (element == null) {
                        set.add(members[index2]);
                    } else {
                        set.add(element);
                    }
                }
                ++index2;
            }
        }
        return set.toArray(new Object[set.size()]);
    }

    private Object[] getPackageFragmentRootChildren(ISynchronizationContext context, Object parent, Object[] children) {
        final HashSet<Object> set = new HashSet<Object>();
        int index = 0;
        while (index < children.length) {
            ISourceFolder fragment;
            if (!(children[index] instanceof ISourceFolder) || !(fragment = (ISourceFolder)children[index]).isOpen() || this.getChildren(fragment).length != 0) {
                set.add(children[index]);
            }
            ++index;
        }
        IResource resource = AsnModelProvider.getResource(parent);
        if (resource != null) {
            final IResourceDiffTree tree = context.getDiffTree();
            IResource[] members = tree.members(resource);
            int index2 = 0;
            while (index2 < members.length) {
                IAsnElement element;
                int type = members[index2].getType();
                boolean contained = this.isInScope(context.getScope(), parent, members[index2]);
                boolean visible = this.isVisible(context, members[index2]);
                if (type == 1 && contained && visible) {
                    element = AsnCore.create((IFile)((IFile)members[index2]));
                    if (element == null) {
                        set.add(members[index2]);
                    }
                } else if (type == 2 && contained && visible && tree.getDiff(members[index2]) != null && (element = AsnCore.create((IResource)members[index2])) != null) {
                    set.add(element);
                }
                if (type == 2) {
                    IFolder folder = (IFolder)members[index2];
                    tree.accept(folder.getFullPath(), new IDiffVisitor(){

                        public final boolean visit(IDiff diff) {
                            IResource current;
                            if (AsnSynchronizationContentProvider.this.isVisible(diff) && (current = tree.getResource(diff)) != null) {
                                int kind = current.getType();
                                if (kind == 1) {
                                    IAsnElement element = AsnCore.create((IResource)current.getParent());
                                    if (element != null) {
                                        set.add(element);
                                    }
                                } else {
                                    IAsnElement element = AsnCore.create((IResource)current);
                                    if (element != null) {
                                        set.add(element);
                                    }
                                }
                            }
                            return true;
                        }
                    }, 2);
                }
                ++index2;
            }
            return set.toArray(new Object[set.size()]);
        }
        return children;
    }

    public void getPipelinedChildren(Object parent, Set children) {
        if (parent instanceof ISynchronizationContext) {
            HashSet<IAsnProject> result = new HashSet<IAsnProject>(children.size());
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                IFolder folder;
                IAsnElement asnElement;
                IAsnProject asn;
                Object element = iterator.next();
                if (element instanceof IProject && (asn = this.asAsnProject((IProject)element)) != null) {
                    iterator.remove();
                    result.add(asn);
                }
                if (!(element instanceof IFolder) || !((asnElement = AsnCore.create((IFolder)(folder = (IFolder)element))) instanceof ISourceFolder)) continue;
                iterator.remove();
            }
            children.addAll(result);
        } else if (parent instanceof ISynchronizationScope) {
            children.add(this.getModelProvider());
        } else if (parent instanceof IFolder) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                IFolder folder;
                IAsnElement asnElement;
                Object element = iterator.next();
                if (!(element instanceof IFolder) || !((asnElement = AsnCore.create((IFolder)(folder = (IFolder)element))) instanceof ISourceFolder)) continue;
                iterator.remove();
            }
        }
    }

    public void getPipelinedElements(Object element, Set elements) {
        this.getPipelinedChildren(element, elements);
    }

    public Object getPipelinedParent(Object element, Object parent) {
        if (element instanceof IAsnElement) {
            return this.getParent(element);
        }
        return parent;
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        return AsnSynchronizationContentProvider.getResourceTraversals(object);
    }

    private Set getVisibleProjects() {
        TreeItem[] children = ((TreeViewer)this.getViewer()).getTree().getItems();
        HashSet<Object> result = new HashSet<Object>();
        int index = 0;
        while (index < children.length) {
            Object data = children[index].getData();
            if (data instanceof IAsnProject) {
                result.add(data);
            }
            ++index;
        }
        return result;
    }

    private void handleChange(IDiffChangeEvent event) {
        Set existing = this.getVisibleProjects();
        IAsnProject[] changed = this.getChangedProjects(event);
        ArrayList<IAsnProject> refreshes = new ArrayList<IAsnProject>(changed.length);
        ArrayList<IAsnProject> additions = new ArrayList<IAsnProject>(changed.length);
        ArrayList<IAsnProject> removals = new ArrayList<IAsnProject>(changed.length);
        int index = 0;
        while (index < changed.length) {
            IAsnProject project = changed[index];
            if (this.hasVisibleChanges(event.getTree(), project)) {
                if (existing.contains(project)) {
                    refreshes.add(project);
                } else {
                    additions.add(project);
                }
            } else {
                removals.add(project);
            }
            ++index;
        }
        Set removed = this.getDeletedProjects(event);
        for (IAsnProject element : existing) {
            if (!removed.contains(element.getResource())) continue;
            removals.add(element);
        }
        if (!(removals.isEmpty() && additions.isEmpty() && refreshes.isEmpty())) {
            TreeViewer viewer = (TreeViewer)this.getViewer();
            Tree tree = viewer.getTree();
            try {
                tree.setRedraw(false);
                if (!additions.isEmpty()) {
                    viewer.add(viewer.getInput(), additions.toArray());
                }
                if (!removals.isEmpty()) {
                    viewer.remove(viewer.getInput(), removals.toArray());
                }
                if (!refreshes.isEmpty()) {
                    Iterator iter = refreshes.iterator();
                    while (iter.hasNext()) {
                        viewer.refresh(iter.next());
                    }
                }
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ICompilationUnit || element instanceof IFile || element instanceof RefactoringDescriptorProxy || element instanceof RefactoringDescriptor) {
            return false;
        }
        return super.hasChildren(element);
    }

    private boolean hasChildrenInScope(ISynchronizationScope scope, Object element, IResource resource) {
        IResource[] roots = scope.getRoots();
        IPath path = resource.getFullPath();
        if (element instanceof ISourceFolder) {
            int index = 0;
            while (index < roots.length) {
                if (path.equals((Object)roots[index].getFullPath().removeLastSegments(1))) {
                    return true;
                }
                ++index;
            }
            return false;
        }
        int index = 0;
        while (index < roots.length) {
            if (path.isPrefixOf(roots[index].getFullPath())) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private boolean hasVisibleChanges(IDiffTree tree, IAsnProject project) {
        return tree.hasMatchingDiffs(project.getResource().getFullPath(), new FastDiffFilter(){

            public boolean select(IDiff diff) {
                return AsnSynchronizationContentProvider.this.isVisible(diff);
            }
        });
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification modification) {
        this.convertToAsnElements(modification);
        return modification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate update) {
        return this.convertToAsnElements(update);
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification modification) {
        this.convertToAsnElements(modification);
        return modification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return this.convertToAsnElements(anUpdateSynchronization);
    }

    protected boolean isInScope(ISynchronizationScope scope, Object parent, Object element) {
        IResource resource = AsnModelProvider.getResource(element);
        if (resource == null) {
            return false;
        }
        if (scope.contains(resource)) {
            return true;
        }
        return this.hasChildrenInScope(scope, element, resource);
    }

    private void syncExec(final Runnable runnable, final Control control) {
        if (control != null && !control.isDisposed()) {
            control.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)runnable);
                    }
                }
            });
        }
    }
}

