/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.preferences.ScrolledPageContent;
import org.asnlab.asndt.internal.ui.util.CoreUtility;
import org.asnlab.asndt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class OptionsConfigurationBlock {
    private static final String REBUILD_COUNT_KEY = "preferences_build_requested";
    private static final String SETTINGS_EXPANDED = "expanded";
    protected final ArrayList fCheckBoxes;
    protected final ArrayList fComboBoxes;
    protected final ArrayList fTextBoxes;
    protected final HashMap fLabels;
    protected final ArrayList fExpandedComposites;
    private SelectionListener fSelectionListener;
    private ModifyListener fTextModifyListener;
    protected IStatusChangeListener fContext;
    protected final IProject fProject;
    protected final Key[] fAllKeys;
    private IScopeContext[] fLookupOrder;
    private Shell fShell;
    private final IWorkingCopyManager fManager;
    private IWorkbenchPreferenceContainer fContainer;
    private Map fDisabledProjectSettings;
    private int fRebuildCount;

    public OptionsConfigurationBlock(IStatusChangeListener context, IProject project, Key[] allKeys, IWorkbenchPreferenceContainer container) {
        this.fContext = context;
        this.fProject = project;
        this.fAllKeys = allKeys;
        this.fContainer = container;
        this.fManager = container == null ? new WorkingCopyManager() : container.getWorkingCopyManager();
        this.fLookupOrder = this.fProject != null ? new IScopeContext[]{new ProjectScope(this.fProject), new InstanceScope(), new DefaultScope()} : new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        this.testIfOptionsComplete(allKeys);
        if (this.fProject == null || this.hasProjectSpecificOptions(this.fProject)) {
            this.fDisabledProjectSettings = null;
        } else {
            this.fDisabledProjectSettings = new IdentityHashMap();
            int i = 0;
            while (i < allKeys.length) {
                Key curr = allKeys[i];
                this.fDisabledProjectSettings.put(curr, curr.getStoredValue(this.fLookupOrder, false, this.fManager));
                ++i;
            }
        }
        this.settingsUpdated();
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList(2);
        this.fLabels = new HashMap();
        this.fExpandedComposites = new ArrayList();
        this.fRebuildCount = this.getRebuildCount();
    }

    protected final IWorkbenchPreferenceContainer getPreferenceContainer() {
        return this.fContainer;
    }

    protected static Key getKey(String plugin, String key) {
        return new Key(plugin, key);
    }

    protected static final Key getASNDTCoreKey(String key) {
        return OptionsConfigurationBlock.getKey("org.asnlab.asndt.core", key);
    }

    protected static final Key getASNDTUIKey(String key) {
        return OptionsConfigurationBlock.getKey("org.asnlab.asndt.ui", key);
    }

    private void testIfOptionsComplete(Key[] allKeys) {
        int i = 0;
        while (i < allKeys.length) {
            if (allKeys[i].getStoredValue(this.fLookupOrder, false, this.fManager) == null) {
                AsnPlugin.logErrorMessage("preference option missing: " + String.valueOf(allKeys[i]) + " (" + this.getClass().getName() + ")");
            }
            ++i;
        }
    }

    private int getRebuildCount() {
        return this.fManager.getWorkingCopy(new DefaultScope().getNode("org.asnlab.asndt.ui")).getInt(REBUILD_COUNT_KEY, 0);
    }

    private void incrementRebuildCount() {
        ++this.fRebuildCount;
        this.fManager.getWorkingCopy(new DefaultScope().getNode("org.asnlab.asndt.ui")).putInt(REBUILD_COUNT_KEY, this.fRebuildCount);
    }

    protected void settingsUpdated() {
    }

    public void selectOption(String key, String qualifier) {
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            if (curr.getName().equals(key) && curr.getQualifier().equals(qualifier)) {
                this.selectOption(curr);
            }
            ++i;
        }
    }

    public void selectOption(Key key) {
        Control control = this.findControl(key);
        if (control != null) {
            ExpandableComposite expandable;
            if (!this.fExpandedComposites.isEmpty() && (expandable = this.getParentExpandableComposite(control)) != null) {
                int i = 0;
                while (i < this.fExpandedComposites.size()) {
                    ExpandableComposite curr;
                    curr.setExpanded((curr = (ExpandableComposite)this.fExpandedComposites.get(i)) == expandable);
                    ++i;
                }
                this.expandedStateChanged(expandable);
            }
            control.setFocus();
        }
    }

    public final boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            ProjectScope projectContext = new ProjectScope(project);
            Key[] allKeys = this.fAllKeys;
            int i = 0;
            while (i < allKeys.length) {
                if (allKeys[i].getStoredValue((IScopeContext)projectContext, this.fManager) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected Button addCheckBox(Composite parent, String label, Key key, String[] values, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Button checkBox = new Button(parent, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setText(label);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.getSelectionListener());
        this.makeScrollableCompositeAware((Control)checkBox);
        String currValue = this.getValue(key);
        checkBox.setSelection(data.getSelection(currValue) == 0);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    protected Button addCheckBoxWithLink(Composite parent, String label, Key key, String[] values, int indent, int widthHint, SelectionListener listener) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        Button checkBox = new Button(composite, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)new GridData(4, 1, false, false));
        checkBox.addSelectionListener(this.getSelectionListener());
        gd = new GridData(4, 2, true, false);
        gd.widthHint = widthHint;
        Link link = new Link(composite, 0);
        link.setText(label);
        link.setLayoutData((Object)gd);
        if (listener != null) {
            link.addSelectionListener(listener);
        }
        this.makeScrollableCompositeAware((Control)link);
        this.makeScrollableCompositeAware((Control)checkBox);
        String currValue = this.getValue(key);
        checkBox.setSelection(data.getSelection(currValue) == 0);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    protected Combo addComboBox(Composite parent, String label, Key key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16384);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(parent, key, values, valueLabels);
        comboBox.setLayoutData((Object)new GridData(256));
        this.fLabels.put(comboBox, labelControl);
        return comboBox;
    }

    protected Combo addInversedComboBox(Composite parent, String label, Key key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(composite, key, values, valueLabels);
        comboBox.setFont(JFaceResources.getDialogFont());
        comboBox.setLayoutData((Object)new GridData(256));
        Label labelControl = new Label(composite, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData());
        this.fLabels.put(comboBox, labelControl);
        return comboBox;
    }

    protected Combo newComboControl(Composite composite, Key key, String[] values, String[] valueLabels) {
        ControlData data = new ControlData(key, values);
        Combo comboBox = new Combo(composite, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.addSelectionListener(this.getSelectionListener());
        comboBox.setFont(JFaceResources.getDialogFont());
        this.makeScrollableCompositeAware((Control)comboBox);
        String currValue = this.getValue(key);
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    protected Text addTextField(Composite parent, String label, Key key, int indent, int widthHint) {
        Label labelControl = new Label(parent, 64);
        labelControl.setText(label);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setLayoutData((Object)new GridData());
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        textBox.setLayoutData((Object)new GridData());
        this.makeScrollableCompositeAware((Control)textBox);
        this.fLabels.put(textBox, labelControl);
        String currValue = this.getValue(key);
        if (currValue != null) {
            textBox.setText(currValue);
        }
        textBox.addModifyListener(this.getTextModifyListener());
        GridData data = new GridData(256);
        if (widthHint != 0) {
            data.widthHint = widthHint;
        }
        data.horizontalIndent = indent;
        data.horizontalSpan = 2;
        textBox.setLayoutData((Object)data);
        this.fTextBoxes.add(textBox);
        return textBox;
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected ExpandableComposite getParentExpandableComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ExpandableComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ExpandableComposite) {
            return (ExpandableComposite)parent;
        }
        return null;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OptionsConfigurationBlock.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.fExpandedComposites.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    protected final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    protected void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandedComposites.size()) {
            ExpandableComposite excomposite = (ExpandableComposite)this.fExpandedComposites.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + String.valueOf(i)));
            }
            ++i;
        }
    }

    protected void storeSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandedComposites.size()) {
            ExpandableComposite curr = (ExpandableComposite)this.fExpandedComposites.get(i);
            settings.put(SETTINGS_EXPANDED + String.valueOf(i), curr.isExpanded());
            ++i;
        }
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OptionsConfigurationBlock.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.fTextModifyListener == null) {
            this.fTextModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OptionsConfigurationBlock.this.textChanged((Text)e.widget);
                }
            };
        }
        return this.fTextModifyListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            newValue = data.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        String oldValue = this.setValue(data.getKey(), newValue);
        this.validateSettings(data.getKey(), oldValue, newValue);
    }

    protected void textChanged(Text textControl) {
        Key key = (Key)textControl.getData();
        String number = textControl.getText();
        String oldValue = this.setValue(key, number);
        this.validateSettings(key, oldValue, number);
    }

    protected boolean checkValue(Key key, String value) {
        return value.equals(this.getValue(key));
    }

    protected String getValue(Key key) {
        if (this.fDisabledProjectSettings != null) {
            return (String)this.fDisabledProjectSettings.get(key);
        }
        return key.getStoredValue(this.fLookupOrder, false, this.fManager);
    }

    protected boolean getBooleanValue(Key key) {
        return Boolean.valueOf(this.getValue(key));
    }

    protected String setValue(Key key, String value) {
        if (this.fDisabledProjectSettings != null) {
            return this.fDisabledProjectSettings.put(key, value);
        }
        String oldValue = this.getValue(key);
        key.setStoredValue(this.fLookupOrder[0], value, this.fManager);
        return oldValue;
    }

    protected String setValue(Key key, boolean value) {
        return this.setValue(key, String.valueOf(value));
    }

    protected String getStoredValue(Key key) {
        return key.getStoredValue(this.fLookupOrder, false, this.fManager);
    }

    protected abstract void validateSettings(Key var1, String var2, String var3);

    protected String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }

    private boolean getChanges(IScopeContext currContext, List changedSettings) {
        boolean needsBuild = false;
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key key = this.fAllKeys[i];
            String oldVal = key.getStoredValue(currContext, null);
            String val = key.getStoredValue(currContext, this.fManager);
            if (val == null) {
                if (oldVal != null) {
                    changedSettings.add(key);
                    needsBuild |= !oldVal.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
                }
            } else if (!val.equals(oldVal)) {
                changedSettings.add(key);
                needsBuild |= oldVal != null || !val.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
            }
            ++i;
        }
        return needsBuild;
    }

    public void useProjectSpecificSettings(boolean enable) {
        boolean hasProjectSpecificOption;
        boolean bl = hasProjectSpecificOption = this.fDisabledProjectSettings == null;
        if (enable != hasProjectSpecificOption && this.fProject != null) {
            if (enable) {
                int i = 0;
                while (i < this.fAllKeys.length) {
                    Key curr = this.fAllKeys[i];
                    String val = (String)this.fDisabledProjectSettings.get(curr);
                    curr.setStoredValue(this.fLookupOrder[0], val, this.fManager);
                    ++i;
                }
                this.fDisabledProjectSettings = null;
                this.updateControls();
                this.validateSettings(null, null, null);
            } else {
                this.fDisabledProjectSettings = new IdentityHashMap();
                int i = 0;
                while (i < this.fAllKeys.length) {
                    Key curr = this.fAllKeys[i];
                    String oldSetting = curr.getStoredValue(this.fLookupOrder, false, this.fManager);
                    this.fDisabledProjectSettings.put(curr, oldSetting);
                    curr.setStoredValue(this.fLookupOrder[0], null, this.fManager);
                    ++i;
                }
            }
        }
    }

    public boolean areSettingsEnabled() {
        return this.fDisabledProjectSettings == null || this.fProject == null;
    }

    public boolean performOk() {
        return this.processChanges(this.fContainer);
    }

    public boolean performApply() {
        return this.processChanges(null);
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        String[] strings;
        int count;
        IScopeContext currContext = this.fLookupOrder[0];
        ArrayList changedOptions = new ArrayList();
        boolean needsBuild = this.getChanges(currContext, changedOptions);
        if (changedOptions.isEmpty()) {
            return true;
        }
        if (needsBuild && (count = this.getRebuildCount()) > this.fRebuildCount) {
            needsBuild = false;
            this.fRebuildCount = count;
        }
        boolean doBuild = false;
        if (needsBuild && (strings = this.getFullBuildDialogStrings(this.fProject == null)) != null) {
            MessageDialog dialog = new MessageDialog(this.getShell(), strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int res = dialog.open();
            if (res == 0) {
                doBuild = true;
            } else if (res != 1) {
                return false;
            }
        }
        if (container != null) {
            if (doBuild) {
                this.incrementRebuildCount();
                container.registerUpdateJob(CoreUtility.getBuildJob(this.fProject));
            }
        } else {
            try {
                this.fManager.applyChanges();
            }
            catch (BackingStoreException e) {
                AsnPlugin.log(e);
                return false;
            }
            if (doBuild) {
                CoreUtility.getBuildJob(this.fProject).schedule();
            }
        }
        return true;
    }

    protected abstract String[] getFullBuildDialogStrings(boolean var1);

    public void performDefaults() {
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            String defValue = curr.getStoredValue(this.fLookupOrder, true, this.fManager);
            this.setValue(curr, defValue);
            ++i;
        }
        this.settingsUpdated();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void performRevert() {
        int i = 0;
        while (i < this.fAllKeys.length) {
            Key curr = this.fAllKeys[i];
            String origValue = curr.getStoredValue(this.fLookupOrder, false, null);
            this.setValue(curr, origValue);
            ++i;
        }
        this.settingsUpdated();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void dispose() {
    }

    protected void updateControls() {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            this.updateCheckBox((Button)this.fCheckBoxes.get(i));
            --i;
        }
        i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            this.updateCombo((Combo)this.fComboBoxes.get(i));
            --i;
        }
        i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            this.updateText((Text)this.fTextBoxes.get(i));
            --i;
        }
    }

    protected void updateCombo(Combo curr) {
        ControlData data = (ControlData)curr.getData();
        String currValue = this.getValue(data.getKey());
        curr.select(data.getSelection(currValue));
    }

    protected void updateCheckBox(Button curr) {
        String currValue;
        ControlData data = (ControlData)curr.getData();
        curr.setSelection(data.getSelection(currValue = this.getValue(data.getKey())) == 0);
    }

    protected void updateText(Text curr) {
        Key key = (Key)curr.getData();
        String currValue = this.getValue(key);
        if (currValue != null) {
            curr.setText(currValue);
        }
    }

    protected Button getCheckBox(Key key) {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            Button curr = (Button)this.fCheckBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Combo getComboBox(Key key) {
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            Combo curr = (Combo)this.fComboBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Text getTextControl(Key key) {
        int i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            Text curr = (Text)this.fTextBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Control findControl(Key key) {
        Combo comboBox = this.getComboBox(key);
        if (comboBox != null) {
            return comboBox;
        }
        Button checkBox = this.getCheckBox(key);
        if (checkBox != null) {
            return checkBox;
        }
        Text text = this.getTextControl(key);
        if (text != null) {
            return text;
        }
        return null;
    }

    protected void setComboEnabled(Key key, boolean enabled) {
        Combo combo = this.getComboBox(key);
        Label label = (Label)this.fLabels.get(combo);
        combo.setEnabled(enabled);
        label.setEnabled(enabled);
    }

    protected static class ControlData {
        private Key fKey;
        private String[] fValues;

        public ControlData(Key key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public Key getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.fValues.length) {
                    if (value.equals(this.fValues[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.fValues.length - 1;
        }
    }

    public static final class Key {
        private String fQualifier;
        private String fKey;

        public Key(String qualifier, String key) {
            this.fQualifier = qualifier;
            this.fKey = key;
        }

        public String getName() {
            return this.fKey;
        }

        private IEclipsePreferences getNode(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = context.getNode(this.fQualifier);
            if (manager != null) {
                return manager.getWorkingCopy(node);
            }
            return node;
        }

        public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
            return this.getNode(context, manager).get(this.fKey, null);
        }

        public String getStoredValue(IScopeContext[] lookupOrder, boolean ignoreTopScope, IWorkingCopyManager manager) {
            int i = ignoreTopScope ? 1 : 0;
            while (i < lookupOrder.length) {
                String value = this.getStoredValue(lookupOrder[i], manager);
                if (value != null) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
            if (value != null) {
                this.getNode(context, manager).put(this.fKey, value);
            } else {
                this.getNode(context, manager).remove(this.fKey);
            }
        }

        public String toString() {
            return this.fQualifier + "/" + this.fKey;
        }

        public String getQualifier() {
            return this.fQualifier;
        }
    }
}

