/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn;

import org.asnlab.asndt.internal.ui.text.asn.AsnDoubleClickSelector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;

public class AsnStringDoubleClickSelector
extends AsnDoubleClickSelector {
    private String fPartitioning;

    public AsnStringDoubleClickSelector(String partitioning) {
        this.fPartitioning = partitioning;
    }

    @Override
    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        IDocument document = textViewer.getDocument();
        IRegion region = this.match(document, offset);
        if (region != null && region.getLength() >= 2) {
            textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
        } else {
            region = this.selectWord(document, offset);
            textViewer.setSelectedRange(region.getOffset(), region.getLength());
        }
    }

    private IRegion match(IDocument document, int offset) {
        try {
            if (document.getChar(offset) == '\"' || document.getChar(offset) == '\'' || document.getChar(offset - 1) == '\"' || document.getChar(offset - 1) == '\'') {
                return TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)offset, (boolean)true);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }
}

