/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn.hover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.AsnPluginImages;
import org.asnlab.asndt.internal.ui.asneditor.AsnMarkerAnnotation;
import org.asnlab.asndt.internal.ui.asneditor.CompilationUnitDocumentProvider;
import org.asnlab.asndt.internal.ui.asneditor.IAsnAnnotation;
import org.asnlab.asndt.internal.ui.text.asn.hover.AnnotationExpandHover;
import org.asnlab.asndt.internal.ui.text.asn.hover.AnnotationExpansionControl;
import org.asnlab.asndt.internal.ui.text.asn.hover.AsnHoverMessages;
import org.asnlab.asndt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;

public class AsnExpandHover
extends AnnotationExpandHover {
    public static final String NO_BREAKPOINT_ANNOTATION = "org.asnlab.asndt.internal.ui.NoBreakpointAnnotation";
    private AnnotationPreferenceLookup fLookup = new AnnotationPreferenceLookup();
    private IPreferenceStore fStore = AsnPlugin.getDefault().getCombinedPreferenceStore();

    public AsnExpandHover(CompositeRuler ruler, IAnnotationAccess access, IDoubleClickListener doubleClickListener) {
        super(ruler, access, doubleClickListener);
    }

    @Override
    protected Object getHoverInfoForLine(final ISourceViewer viewer, final int line) {
        Annotation first;
        boolean showTemporaryProblems = PreferenceConstants.getPreferenceStore().getBoolean("AsnEditor.ShowTemporaryProblem");
        IAnnotationModel model = viewer.getAnnotationModel();
        IDocument document = viewer.getDocument();
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> exact = new ArrayList<Annotation>();
        HashMap messagesAtPosition = new HashMap();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position position;
            String key;
            AnnotationPreference pref;
            Annotation annotation = (Annotation)e.next();
            if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && !((IAnnotationAccessExtension)this.fAnnotationAccess).isPaintable(annotation) || annotation instanceof IAsnAnnotation && !this.isIncluded((IAsnAnnotation)annotation, showTemporaryProblems) || (pref = this.fLookup.getAnnotationPreference(annotation)) != null && (key = pref.getVerticalRulerPreferenceKey()) != null && !this.fStore.getBoolean(key) || (position = model.getPosition(annotation)) == null || this.compareRulerLine(position, document, line) != 1 || this.isDuplicateMessage(messagesAtPosition, position, annotation.getText())) continue;
            exact.add(annotation);
        }
        this.sort(exact, model);
        if (exact.size() > 0) {
            this.setLastRulerMouseLocation(viewer, line);
        }
        if (exact.size() > 0 && !this.isBreakpointAnnotation(first = (Annotation)exact.get(0))) {
            exact.add(0, new NoBreakpointAnnotation());
        }
        if (exact.size() <= 1) {
            return null;
        }
        AnnotationExpansionControl.AnnotationHoverInput input = new AnnotationExpansionControl.AnnotationHoverInput();
        input.fAnnotations = exact.toArray(new Annotation[0]);
        input.fViewer = viewer;
        input.fRulerInfo = this.fCompositeRuler;
        input.fAnnotationListener = this.fgListener;
        input.fDoubleClickListener = this.fDblClickListener;
        input.redoAction = new AnnotationExpansionControl.ICallback(){

            @Override
            public void run(IInformationControlExtension2 control) {
                control.setInput(AsnExpandHover.this.getHoverInfoForLine(viewer, line));
            }
        };
        input.model = model;
        return input;
    }

    private boolean isIncluded(IAsnAnnotation annotation, boolean showTemporaryProblems) {
        if (annotation instanceof CompilationUnitDocumentProvider.ProblemAnnotation && "org.eclipse.ui.workbench.texteditor.task".equals(annotation.getType())) {
            return false;
        }
        if (!annotation.isProblem()) {
            return true;
        }
        if (annotation.isMarkedDeleted() && !annotation.hasOverlay()) {
            return true;
        }
        if (annotation.hasOverlay() && !annotation.isMarkedDeleted()) {
            return true;
        }
        if (annotation.hasOverlay()) {
            return !this.isIncluded(annotation.getOverlay(), showTemporaryProblems);
        }
        return showTemporaryProblems;
    }

    @Override
    protected int getOrder(Annotation annotation) {
        if (this.isBreakpointAnnotation(annotation)) {
            return 1000;
        }
        return super.getOrder(annotation);
    }

    private boolean isBreakpointAnnotation(Annotation a) {
        if (a instanceof AsnMarkerAnnotation) {
            AsnMarkerAnnotation jma = (AsnMarkerAnnotation)a;
            return jma.getType().equals("org.eclipse.debug.core.breakpoint");
        }
        return false;
    }

    private static class NoBreakpointAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        public NoBreakpointAnnotation() {
            super(AsnExpandHover.NO_BREAKPOINT_ANNOTATION, false, AsnHoverMessages.NoBreakpointAnnotation_addBreakpoint);
        }

        public void paint(GC gc, Canvas canvas, Rectangle bounds) {
            Image fImage = AsnPluginImages.get("org.asnlab.asndt.ui.field_public_obj.gif");
            ImageUtilities.drawImage((Image)fImage, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000);
        }

        public int getLayer() {
            return 0;
        }
    }
}

