/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.Page;

public class OpenViewActionGroup
extends ActionGroup {
    private boolean fEditorIsOwner;
    private boolean fIsTypeHiararchyViewerOwner;
    private boolean fIsCallHiararchyViewerOwner;
    private ISelectionProvider fSelectionProvider;
    private PropertyDialogAction fOpenPropertiesDialog;

    public OpenViewActionGroup(Page page) {
        this.createSiteActions((IWorkbenchSite)page.getSite(), null);
    }

    public OpenViewActionGroup(Page page, ISelectionProvider selectionProvider) {
        this.createSiteActions((IWorkbenchSite)page.getSite(), selectionProvider);
    }

    public OpenViewActionGroup(IViewPart part) {
        this(part, null);
    }

    public OpenViewActionGroup(IViewPart part, ISelectionProvider selectionProvider) {
        this.createSiteActions((IWorkbenchSite)part.getSite(), selectionProvider);
        String partName = part.getClass().getName();
        this.fIsTypeHiararchyViewerOwner = "org.asnlab.asndt.internal.ui.typehierarchy.TypeHierarchyViewPart".equals(partName);
        this.fIsCallHiararchyViewerOwner = "org.asnlab.asndt.internal.ui.callhierarchy.CallHierarchyViewPart".equals(partName);
    }

    public OpenViewActionGroup(IWorkbenchSite site, ISelectionProvider selectionProvider) {
        this.createSiteActions(site, selectionProvider);
    }

    public OpenViewActionGroup(AsnEditor part) {
        this.fEditorIsOwner = true;
        this.initialize(part.getEditorSite().getSelectionProvider());
    }

    private void createSiteActions(IWorkbenchSite site, ISelectionProvider specialProvider) {
        ISelectionProvider provider;
        ISelectionProvider iSelectionProvider = provider = specialProvider != null ? specialProvider : site.getSelectionProvider();
        if (this.getShowProperties()) {
            this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)site, provider);
            this.fOpenPropertiesDialog.setActionDefinitionId("org.eclipse.ui.file.properties");
        }
        this.initialize(provider);
    }

    private void initialize(ISelectionProvider provider) {
        this.fSelectionProvider = provider;
        ISelection selection = provider.getSelection();
        if (!this.fEditorIsOwner && this.getShowProperties()) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                this.fOpenPropertiesDialog.selectionChanged(ss);
            } else {
                this.fOpenPropertiesDialog.selectionChanged(selection);
            }
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IStructuredSelection selection = this.getStructuredSelection();
        if (this.getShowProperties() && this.fOpenPropertiesDialog != null && this.fOpenPropertiesDialog.isEnabled() && selection != null && this.fOpenPropertiesDialog.isApplicableForSelection(selection)) {
            menu.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        if (!this.fEditorIsOwner && this.getShowProperties()) {
            actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
        }
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.open", action);
        }
    }

    private IStructuredSelection getStructuredSelection() {
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected boolean getShowProperties() {
        return true;
    }
}

