/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.actions.ASNDTQuickMenuAction;
import org.asnlab.asndt.internal.ui.actions.ActionMessages;
import org.asnlab.asndt.internal.ui.actions.ActionUtil;
import org.asnlab.asndt.internal.ui.actions.SelectionConverter;
import org.asnlab.asndt.internal.ui.asneditor.AsnTextSelection;
import org.asnlab.asndt.internal.ui.asneditor.CompilationUnitEditor;
import org.asnlab.asndt.internal.ui.refactoring.RefactoringMessages;
import org.asnlab.asndt.ui.actions.MoveAction;
import org.asnlab.asndt.ui.actions.RenameAction;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.Page;

public class RefactorActionGroup
extends ActionGroup {
    private static final String PERF_REFACTOR_ACTION_GROUP = "org.asnlab.asndt.ui/perf/explorer/RefactorActionGroup";
    public static final String MENU_ID = "org.asnlab.asndt.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    public static final String GROUP_CODING2 = "codingGroup2";
    private static final String GROUP_REORG2 = "reorgGroup2";
    private static final String GROUP_TYPE2 = "typeGroup2";
    private IWorkbenchSite fSite;
    private CompilationUnitEditor fEditor;
    private String fGroupName = "group.reorganize";
    private SelectionDispatchAction fMoveAction;
    private SelectionDispatchAction fRenameAction;
    private UndoRedoActionGroup fUndoRedoActionGroup;
    private final List fActions = new ArrayList();
    private static final String QUICK_MENU_ID = "org.asnlab.asndt.ui.edit.text.asn.refactor.quickMenu";
    private RefactorQuickAccessAction fQuickAccessAction;
    private IKeyBindingService fKeyBindingService;
    private Action fNoActionAvailable = new NoActionAvailable();

    public RefactorActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), part.getSite().getKeyBindingService());
        IUndoContext workspaceContext = (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class);
        this.fUndoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)part.getViewSite(), workspaceContext, true);
    }

    public RefactorActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public RefactorActionGroup(CompilationUnitEditor editor, String groupName) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        this.fSite = editor.getEditorSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        ISelectionProvider provider = editor.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fRenameAction = new RenameAction(editor);
        this.initAction(this.fRenameAction, selection, "org.asnlab.asndt.ui.edit.text.asn.rename.element");
        editor.setAction("RenameElement", (IAction)this.fRenameAction);
        this.fMoveAction = new MoveAction(editor);
        this.initAction(this.fMoveAction, selection, "org.asnlab.asndt.ui.edit.text.asn.move.element");
        editor.setAction("MoveElement", (IAction)this.fMoveAction);
        this.fQuickAccessAction = new RefactorQuickAccessAction(editor);
        this.fKeyBindingService = editor.getEditorSite().getKeyBindingService();
        this.fKeyBindingService.registerAction((IAction)this.fQuickAccessAction);
        stats.endRun();
    }

    private RefactorActionGroup(IWorkbenchSite site, IKeyBindingService keyBindingService) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fMoveAction = new MoveAction(site);
        this.initUpdatingAction(this.fMoveAction, provider, selection, "org.asnlab.asndt.ui.edit.text.asn.move.element");
        this.fRenameAction = new RenameAction(site);
        this.initUpdatingAction(this.fRenameAction, provider, selection, "org.asnlab.asndt.ui.edit.text.asn.rename.element");
        this.fKeyBindingService = keyBindingService;
        if (this.fKeyBindingService != null) {
            this.fQuickAccessAction = new RefactorQuickAccessAction(null);
            this.fKeyBindingService.registerAction((IAction)this.fQuickAccessAction);
        }
        stats.endRun();
    }

    private void initAction(SelectionDispatchAction action, ISelection selection, String actionDefinitionId) {
        this.initUpdatingAction(action, null, selection, actionDefinitionId);
    }

    private void initUpdatingAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection, String actionDefinitionId) {
        action.setActionDefinitionId(actionDefinitionId);
        action.update(selection);
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
        }
        this.fActions.add(action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.asnlab.asndt.ui.actions.Move", (IAction)this.fMoveAction);
        actionBars.setGlobalActionHandler("org.asnlab.asndt.ui.actions.Rename", (IAction)this.fRenameAction);
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.fillActionBars(actionBars);
        }
    }

    public void retargetFileMenuActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.fMoveAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        this.disposeAction(this.fMoveAction, provider);
        this.disposeAction(this.fRenameAction, provider);
        if (this.fQuickAccessAction != null && this.fKeyBindingService != null) {
            this.fKeyBindingService.unregisterAction((IAction)this.fQuickAccessAction);
        }
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.dispose();
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        String menuText = ActionMessages.RefactorMenu_label;
        if (this.fQuickAccessAction != null) {
            menuText = this.fQuickAccessAction.addShortcut(menuText);
        }
        MenuManager refactorSubmenu = new MenuManager(menuText, MENU_ID);
        if (this.fEditor != null) {
            IAsnElement element = SelectionConverter.getInput(this.fEditor);
            if (element != null && ActionUtil.isOnBuildPath(element)) {
                refactorSubmenu.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        RefactorActionGroup.this.refactorMenuShown(manager);
                    }
                });
                refactorSubmenu.add((IAction)this.fNoActionAvailable);
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        } else {
            ISelection selection = this.fSite.getSelectionProvider().getSelection();
            Iterator iter = this.fActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update(selection);
            }
            if (this.fillRefactorMenu((IMenuManager)refactorSubmenu) > 0) {
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        }
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
        added += this.addAction(refactorSubmenu, (IAction)this.fRenameAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fMoveAction);
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG2));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING2));
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE2));
        return added;
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private void refactorMenuShown(final IMenuManager refactorSubmenu) {
        Menu menu = ((MenuManager)refactorSubmenu).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                RefactorActionGroup.this.refactorMenuHidden(refactorSubmenu);
            }
        });
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        AsnTextSelection asnSelection = new AsnTextSelection(this.getEditorInput(), this.getDocument(), textSelection.getOffset(), textSelection.getLength());
        for (SelectionDispatchAction action : this.fActions) {
            action.update((ISelection)asnSelection);
        }
        refactorSubmenu.removeAll();
        if (this.fillRefactorMenu(refactorSubmenu) == 0) {
            refactorSubmenu.add((IAction)this.fNoActionAvailable);
        }
    }

    private void refactorMenuHidden(IMenuManager manager) {
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        for (SelectionDispatchAction action : this.fActions) {
            action.update((ISelection)textSelection);
        }
    }

    private IAsnElement getEditorInput() {
        return AsnPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
    }

    private IDocument getDocument() {
        return AsnPlugin.getDefault().getCompilationUnitDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private void fillQuickMenu(IMenuManager menu) {
        if (this.fEditor != null) {
            IAsnElement element = SelectionConverter.getInput(this.fEditor);
            if (element == null || !ActionUtil.isOnBuildPath(element)) {
                menu.add((IAction)this.fNoActionAvailable);
                return;
            }
            ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            AsnTextSelection asnSelection = new AsnTextSelection(this.getEditorInput(), this.getDocument(), textSelection.getOffset(), textSelection.getLength());
            Iterator iter = this.fActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update((ISelection)asnSelection);
            }
            this.fillRefactorMenu(menu);
            iter = this.fActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update((ISelection)textSelection);
            }
        } else {
            ISelection selection = this.fSite.getSelectionProvider().getSelection();
            Iterator iter = this.fActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update(selection);
            }
            this.fillRefactorMenu(menu);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(RefactoringMessages.RefactorActionGroup_no_refactoring_available);
        }
    }

    private class RefactorQuickAccessAction
    extends ASNDTQuickMenuAction {
        public RefactorQuickAccessAction(CompilationUnitEditor editor) {
            super(editor, RefactorActionGroup.QUICK_MENU_ID);
        }

        @Override
        protected void fillMenu(IMenuManager menu) {
            RefactorActionGroup.this.fillQuickMenu(menu);
        }
    }
}

