/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.preferences;

import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.asnlab.asndt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractConfigurationBlockPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceConfigurationBlock fConfigurationBlock;
    private OverlayPreferenceStore fOverlayStore;

    public AbstractConfigurationBlockPreferencePage() {
        this.setDescription();
        this.setPreferenceStore();
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), new OverlayPreferenceStore.OverlayKey[0]);
        this.fConfigurationBlock = this.createConfigurationBlock(this.fOverlayStore);
    }

    protected abstract IPreferenceConfigurationBlock createConfigurationBlock(OverlayPreferenceStore var1);

    protected abstract String getHelpId();

    protected abstract void setDescription();

    protected abstract void setPreferenceStore();

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpId());
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Control content = this.fConfigurationBlock.createControl(parent);
        this.initialize();
        Dialog.applyDialogFont((Control)content);
        return content;
    }

    private void initialize() {
        this.fConfigurationBlock.initialize();
    }

    public boolean performOk() {
        this.fConfigurationBlock.performOk();
        this.fOverlayStore.propagate();
        AsnPlugin.getDefault().savePluginPreferences();
        return true;
    }

    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.fConfigurationBlock.performDefaults();
        super.performDefaults();
    }

    public void dispose() {
        this.fConfigurationBlock.dispose();
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }
}

