/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.ASTParser;
import org.asnlab.asndt.core.dom.ASTVisitor;
import org.asnlab.asndt.core.dom.Comment;
import org.asnlab.asndt.core.dom.CompilationUnitDeclaration;
import org.asnlab.asndt.core.dom.DefaultASTVisitor;
import org.asnlab.asndt.core.formatter.IPositionAwareFormattingStrategy;
import org.asnlab.asndt.internal.formatter.CodeFormatterOptions;
import org.asnlab.asndt.internal.formatter.CodeFormatterVisitor;
import org.asnlab.asndt.internal.ui.AsnPlugin;

public class AsnFormattingStrategy
extends IPositionAwareFormattingStrategy {
    private ICompilationUnit compilationUnit;

    public AsnFormattingStrategy(ICompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public void formatterStarts(String initialIndentation) {
    }

    public String format(String content, int offset, int length, boolean isLineStart, String indentation, int[] positions, CodeFormatterOptions options) {
        List<ASTNode> nodes;
        List comments;
        block10: {
            ASTNode ast;
            block9: {
                ast = null;
                comments = null;
                if (this.compilationUnit == null) {
                    ASTParser parser = ASTParser.newParser(null, null);
                    parser.setSource(content.toCharArray());
                    parser.setSourceRange(offset, offset + length - 1);
                    ast = parser.parse(null);
                } else {
                    if (!this.compilationUnit.isConsistent()) {
                        this.compilationUnit.makeConsistent(null);
                    }
                    ast = this.compilationUnit.getAst();
                }
                if (ast != null) break block9;
                return null;
            }
            comments = ((CompilationUnitDeclaration)ast).comments;
            nodes = FormattingNodesFinder.find(ast, offset, length);
            if (nodes.size() >= 1) break block10;
            return null;
        }
        try {
            if (options == null) {
                IAsnProject project = this.compilationUnit == null ? null : this.compilationUnit.getAsnProject();
                Map setting = project == null ? null : project.getOptions(true);
                options = CodeFormatterOptions.getShare((Map)setting);
            }
            StringBuffer buff = new StringBuffer();
            int start = offset;
            for (ASTNode node : nodes) {
                int prefixLen = node.sourceStart - start;
                int index = start - offset;
                String prefix = content.substring(index, index + prefixLen);
                buff.append(prefix);
                List<Comment> nodeComments = this.findComments(comments, node.sourceStart, node.sourceEnd);
                CodeFormatterVisitor visitor = new CodeFormatterVisitor(options, indentation, nodeComments);
                node.accept((ASTVisitor)visitor);
                String formatted = visitor.getFormattedContent();
                buff.append(formatted);
                start = node.sourceEnd + 1;
            }
            int sufixLen = offset + length - start;
            String sufix = content.substring(content.length() - sufixLen);
            buff.append(sufix);
            return buff.toString();
        }
        catch (AsnModelException x) {
            AsnPlugin.log(x);
            return null;
        }
    }

    private List<Comment> findComments(List<Comment> comments, int start, int end) {
        if (comments == null) {
            return null;
        }
        LinkedList<Comment> found = new LinkedList<Comment>();
        for (Comment comment : comments) {
            if (comment.sourceStart < start || comment.sourceEnd > end) continue;
            found.addLast(comment);
        }
        return found;
    }

    public void formatterStops() {
    }

    static class FormattingNodesFinder
    extends DefaultASTVisitor {
        ArrayList<ASTNode> foundNodes = new ArrayList();
        int start;
        int end;

        static List<ASTNode> find(ASTNode root, int offset, int length) {
            FormattingNodesFinder finder = new FormattingNodesFinder(offset, length);
            root.accept((ASTVisitor)finder);
            return finder.foundNodes;
        }

        FormattingNodesFinder(int offset, int length) {
            this.start = offset;
            this.end = offset + length;
        }

        protected boolean visitNode(ASTNode node) {
            if (node.getSourceStart() >= this.start && node.getSourceEnd() <= this.end) {
                this.foundNodes.add(node);
                return false;
            }
            return true;
        }
    }
}

