/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn.hover;

import java.util.ArrayList;
import java.util.List;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.text.asn.hover.AbstractAsnEditorTextHover;
import org.asnlab.asndt.internal.ui.text.asn.hover.AsnEditorTextHoverDescriptor;
import org.asnlab.asndt.ui.text.asn.hover.IAsnEditorTextHover;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;

public class BestMatchHover
extends AbstractAsnEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private List fTextHoverSpecifications;
    private List fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        this.installTextHovers();
    }

    public BestMatchHover(IEditorPart editor) {
        this();
        this.setEditor(editor);
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList(2);
        this.fInstantiatedTextHovers = new ArrayList(2);
        AsnEditorTextHoverDescriptor[] hoverDescs = AsnPlugin.getDefault().getAsnEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (!"org.asnlab.asndt.ui.BestMatchHover".equals(hoverDescs[i].getId())) {
                this.fTextHoverSpecifications.add(hoverDescs[i]);
            }
            ++i;
        }
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications.size() == 0) {
            return;
        }
        for (AsnEditorTextHoverDescriptor spec : new ArrayList(this.fTextHoverSpecifications)) {
            IAsnEditorTextHover hover = spec.createTextHover();
            if (hover == null) continue;
            hover.setEditor(this.getEditor());
            this.addTextHover(hover);
            this.fTextHoverSpecifications.remove(spec);
        }
    }

    protected void addTextHover(ITextHover hover) {
        if (!this.fInstantiatedTextHovers.contains(hover)) {
            this.fInstantiatedTextHovers.add(hover);
        }
    }

    @Override
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover hover : this.fInstantiatedTextHovers) {
            String s = hover.getHoverInfo(textViewer, hoverRegion);
            if (s == null || s.trim().length() <= 0) continue;
            this.fBestHover = hover;
            return s;
        }
        return null;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

