/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.DefinedObjectClass;
import org.asnlab.asndt.core.dom.DefinedType;
import org.asnlab.asndt.core.dom.DefinedValue;
import org.asnlab.asndt.core.dom.Name;
import org.asnlab.asndt.core.dom.Parameter;
import org.asnlab.asndt.core.dom.PrimitiveFieldName;
import org.asnlab.asndt.core.dom.StructuralPropertyDescriptor;
import org.asnlab.asndt.core.dom.SymbolsFromModule;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditorMessages;
import org.asnlab.asndt.internal.ui.asneditor.SemanticHighlighting;
import org.asnlab.asndt.internal.ui.asneditor.SemanticToken;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class SemanticHighlightings {
    public static final String MODULE = "module";
    public static final String CLASS = "class";
    public static final String FIELD = "field";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String COMPONENT = "component";
    private static SemanticHighlighting[] fgSemanticHighlightings;

    public static String getColorPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".color";
    }

    public static String getBoldPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".bold";
    }

    public static String getItalicPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".italic";
    }

    public static String getStrikethroughPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".strikethrough";
    }

    public static String getUnderlinePreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".underline";
    }

    public static String getEnabledPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".enabled";
    }

    public static SemanticHighlighting[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new SemanticHighlighting[]{new ModuleHighlighting(), new ClassHighlighting(), new FieldHighlighting(), new ValueHighlighting(), new TypeHighlighting(), new ComponentHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    public static void initDefaults(IPreferenceStore store) {
        SemanticHighlighting[] semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        int n = semanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = semanticHighlightings[i];
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)SemanticHighlightings.getColorPreferenceKey(semanticHighlighting), (RGB)semanticHighlighting.getDefaultTextColor());
            store.setDefault(SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting), semanticHighlighting.isBoldByDefault());
            store.setDefault(SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting), semanticHighlighting.isItalicByDefault());
            store.setDefault(SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting), semanticHighlighting.isStrikethroughByDefault());
            store.setDefault(SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting), semanticHighlighting.isUnderlineByDefault());
            store.setDefault(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting), semanticHighlighting.isEnabledByDefault());
            ++i;
        }
    }

    public static boolean affectsEnablement(IPreferenceStore store, PropertyChangeEvent event) {
        String relevantKey = null;
        SemanticHighlighting[] highlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        while (i < highlightings.length) {
            if (event.getProperty().equals(SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]))) {
                relevantKey = event.getProperty();
                break;
            }
            ++i;
        }
        if (relevantKey == null) {
            return false;
        }
        i = 0;
        while (i < highlightings.length) {
            String key = SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (!key.equals(relevantKey) && store.getBoolean(key)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEnabled(IPreferenceStore store) {
        SemanticHighlighting[] highlightings = SemanticHighlightings.getSemanticHighlightings();
        boolean enable = false;
        int i = 0;
        while (i < highlightings.length) {
            String enabledKey = SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (store.getBoolean(enabledKey)) {
                enable = true;
                break;
            }
            ++i;
        }
        return enable;
    }

    private SemanticHighlightings() {
    }

    private static final class ClassHighlighting
    extends SemanticHighlighting {
        private ClassHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.CLASS;
        }

        @Override
        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return AsnEditorMessages.SemanticHighlighting_class;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            Name name = token.getNode();
            ASTNode node = name.getParent();
            int nodeType = node.getNodeType();
            if (nodeType == 5) {
                return name.isWord();
            }
            if (nodeType == 8) {
                StructuralPropertyDescriptor location = name.getLocationInParent();
                if (location == SymbolsFromModule.SYMBOLS_PROPERTY) {
                    return name.isWord();
                }
            } else {
                StructuralPropertyDescriptor location;
                if (nodeType == 122) {
                    return true;
                }
                if (nodeType == 133) {
                    return name.isWord();
                }
                if (nodeType == 130) {
                    Parameter parameter = (Parameter)node.getParent();
                    return parameter.getParamGovernor() == null && name.isWord();
                }
                if (nodeType == 82 && (location = name.getLocationInParent()) == DefinedObjectClass.CLASS_NAME_PROPERTY) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class ComponentHighlighting
    extends SemanticHighlighting {
        private ComponentHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.COMPONENT;
        }

        @Override
        public RGB getDefaultTextColor() {
            return new RGB(184, 134, 11);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return AsnEditorMessages.SemanticHighlighting_component;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            Name name = token.getNode();
            ASTNode node = name.getParent();
            int nodeType = node.getNodeType();
            return nodeType == 18 || nodeType == 17 || nodeType == 43 || nodeType == 41;
        }
    }

    private static final class FieldHighlighting
    extends SemanticHighlighting {
        private FieldHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.FIELD;
        }

        @Override
        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return AsnEditorMessages.SemanticHighlighting_field;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            return false;
        }

        @Override
        public boolean consumesFieldName(SemanticToken token) {
            PrimitiveFieldName name = token.getFieldName();
            return name != null;
        }
    }

    private static final class ModuleHighlighting
    extends SemanticHighlighting {
        private ModuleHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.MODULE;
        }

        @Override
        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return AsnEditorMessages.SemanticHighlighting_module;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            StructuralPropertyDescriptor location;
            Name name = token.getNode();
            ASTNode node = name.getParent();
            int nodeType = node.getNodeType();
            if (nodeType == 2) {
                return true;
            }
            return nodeType == 8 ? (location = name.getLocationInParent()) == SymbolsFromModule.NAME_PROPERTY : !(nodeType != 32 && nodeType != 54 || (location = name.getLocationInParent()) != DefinedType.MODULE_NAME_PROPERTY && location != DefinedValue.MODULE_NAME_PROPERTY);
        }
    }

    private static final class TypeHighlighting
    extends SemanticHighlighting {
        private TypeHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.TYPE;
        }

        @Override
        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return AsnEditorMessages.SemanticHighlighting_type;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            Name name = token.getNode();
            ASTNode node = name.getParent();
            int nodeType = node.getNodeType();
            if (nodeType == 5) {
                return name.isReference();
            }
            if (nodeType == 8) {
                StructuralPropertyDescriptor location = name.getLocationInParent();
                if (location == SymbolsFromModule.SYMBOLS_PROPERTY) {
                    return name.isReference();
                }
            } else {
                StructuralPropertyDescriptor location;
                if (nodeType == 10) {
                    return true;
                }
                if (nodeType == 133) {
                    return name.isReference();
                }
                if (nodeType == 130) {
                    Parameter parameter = (Parameter)node.getParent();
                    return parameter.getParamGovernor() == null && name.isReference();
                }
                if (nodeType == 32 && (location = name.getLocationInParent()) == DefinedType.TYPE_NAME_PROPERTY) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class ValueHighlighting
    extends SemanticHighlighting {
        private ValueHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.VALUE;
        }

        @Override
        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return AsnEditorMessages.SemanticHighlighting_value;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            Name name = token.getNode();
            ASTNode node = name.getParent();
            int nodeType = node.getNodeType();
            if (nodeType == 5) {
                return name.isIdentifier();
            }
            if (nodeType == 8) {
                StructuralPropertyDescriptor location = name.getLocationInParent();
                if (location == SymbolsFromModule.SYMBOLS_PROPERTY) {
                    return name.isIdentifier();
                }
            } else {
                if (nodeType == 37) {
                    return true;
                }
                if (nodeType == 130) {
                    Parameter parameter = (Parameter)node.getParent();
                    return parameter.getParamGovernor() != null && name.isIdentifier();
                }
                if (nodeType == 54) {
                    StructuralPropertyDescriptor location = name.getLocationInParent();
                    if (location == DefinedValue.VALUE_NAME_PROPERTY) {
                        return true;
                    }
                } else {
                    if (nodeType == 13) {
                        return true;
                    }
                    if (nodeType == 52) {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

