/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.refactoring.actions;

import org.asnlab.asndt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.asnlab.asndt.internal.ui.actions.ActionUtil;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class RenameResourceAction
extends SelectionDispatchAction {
    public RenameResourceAction(IWorkbenchSite site) {
        super(site);
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        IResource element = RenameResourceAction.getResource(selection);
        if (element == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(RefactoringAvailabilityTester.isRenameAvailable(element));
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        IResource resource = RenameResourceAction.getResource(selection);
        if (!ActionUtil.isProcessable(this.getShell(), resource)) {
            return;
        }
        if (!RefactoringAvailabilityTester.isRenameAvailable(resource)) {
            return;
        }
    }

    private static IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IResource)) {
            return null;
        }
        return (IResource)first;
    }
}

