/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.ASTVisitor;
import org.asnlab.asndt.core.dom.CompilationUnitDeclaration;
import org.asnlab.asndt.core.dom.Name;
import org.asnlab.asndt.core.dom.TypeAssignment;
import org.asnlab.asndt.internal.corext.dom.NodeFinder;
import org.asnlab.asndt.internal.ui.search.IOccurrencesFinder;
import org.asnlab.asndt.internal.ui.search.OccurrencesGroupKey;
import org.asnlab.asndt.internal.ui.search.SearchMessages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;

public class OccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String IS_WRITEACCESS = "writeAccess";
    public static final String IS_VARIABLE = "variable";
    private CompilationUnitDeclaration fRoot;
    private Name fSelectedNode;
    private ASTNode fTarget;
    private List fUsages = new ArrayList();
    private List fWriteUsages = new ArrayList();

    public OccurrencesFinder(ASTNode target) {
        this.fTarget = target;
    }

    public OccurrencesFinder() {
    }

    @Override
    public String initialize(CompilationUnitDeclaration root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, offset, length));
    }

    public String initialize(CompilationUnitDeclaration root, ASTNode node) {
        if (!(node instanceof Name)) {
            return SearchMessages.OccurrencesFinder_no_element;
        }
        this.fRoot = root;
        this.fSelectedNode = (Name)node;
        this.fTarget = node;
        return null;
    }

    @Override
    public List perform() {
        this.fRoot.accept((ASTVisitor)this);
        return this.fUsages;
    }

    @Override
    public void collectOccurrenceMatches(IAsnElement element, IDocument document, Collection resultingMatches) {
        HashMap<Integer, OccurrencesGroupKey> lineToGroup = new HashMap<Integer, OccurrencesGroupKey>();
        for (ASTNode node : this.fUsages) {
            int startPosition = node.getSourceStart();
            int length = node.getSourceEnd() - startPosition + 1;
            try {
                boolean isWriteAccess = this.fWriteUsages.contains(node);
                int line = document.getLineOfOffset(startPosition);
                Integer lineInteger = new Integer(line);
                OccurrencesGroupKey groupKey = (OccurrencesGroupKey)lineToGroup.get(lineInteger);
                if (groupKey == null) {
                    IRegion region = document.getLineInformation(line);
                    String lineContents = document.get(region.getOffset(), region.getLength()).trim();
                    groupKey = new OccurrencesGroupKey(element, line, lineContents, isWriteAccess);
                    lineToGroup.put(lineInteger, groupKey);
                } else if (isWriteAccess) {
                    groupKey.setWriteAccess(true);
                }
                Match match = new Match((Object)groupKey, startPosition, length);
                resultingMatches.add(match);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    @Override
    public String getJobLabel() {
        return SearchMessages.OccurrencesFinder_searchfor;
    }

    @Override
    public String getElementName() {
        if (this.fSelectedNode != null && this.fSelectedNode instanceof Name) {
            return this.fSelectedNode.getIdentifier();
        }
        return null;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return SearchMessages.OccurrencesFinder_label_plural;
    }

    @Override
    public String getUnformattedSingularLabel() {
        return SearchMessages.OccurrencesFinder_label_singular;
    }

    public boolean visit(Name node) {
        return !this.match(node, this.fUsages);
    }

    public boolean visit(TypeAssignment node) {
        Name name = node.getName();
        if (name != null) {
            this.match(name, this.fWriteUsages);
        }
        return false;
    }

    private boolean match(Name node, List result) {
        return false;
    }
}

