/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.dom;

import org.asnlab.asndt.core.ToolFactory;
import org.asnlab.asndt.core.compiler.IScanner;
import org.asnlab.asndt.core.compiler.InvalidInputException;
import org.asnlab.asndt.internal.ui.AsnUIStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class TokenScanner {
    public static final int END_OF_FILE = 20001;
    public static final int LEXICAL_ERROR = 20002;
    public static final int DOCUMENT_ERROR = 20003;
    private IScanner fScanner;
    private IDocument fDocument;
    private int fEndPosition;

    public TokenScanner(IScanner scanner) {
        this(scanner, null);
    }

    public TokenScanner(IScanner scanner, IDocument document) {
        this.fScanner = scanner;
        this.fEndPosition = this.fScanner.getSource().length - 1;
        this.fDocument = document;
    }

    public TokenScanner(IDocument document) {
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        this.fScanner.setSource(document.get().toCharArray());
        this.fDocument = document;
        this.fEndPosition = this.fScanner.getSource().length - 1;
    }

    public IScanner getScanner() {
        return this.fScanner;
    }

    public void setOffset(int offset) {
        this.fScanner.resetTo(offset, this.fEndPosition);
    }

    public int getCurrentEndOffset() {
        return this.fScanner.getCurrentTokenEndPosition() + 1;
    }

    public int getCurrentStartOffset() {
        return this.fScanner.getCurrentTokenStartPosition();
    }

    public int getCurrentLength() {
        return this.getCurrentEndOffset() - this.getCurrentStartOffset();
    }

    public int readNext(boolean ignoreComments) throws CoreException {
        int curr = 0;
        do {
            try {
                curr = this.fScanner.getNextToken();
                if (curr == 1000) {
                    throw new CoreException(this.createError(20001, "End Of File", null));
                }
            }
            catch (InvalidInputException e) {
                throw new CoreException(this.createError(20002, e.getMessage(), e));
            }
        } while (ignoreComments && TokenScanner.isComment(curr));
        return curr;
    }

    private int readNextWithEOF(boolean ignoreComments) throws CoreException {
        int curr = 0;
        do {
            try {
                curr = this.fScanner.getNextToken();
            }
            catch (InvalidInputException e) {
                throw new CoreException(this.createError(20002, e.getMessage(), e));
            }
        } while (ignoreComments && TokenScanner.isComment(curr));
        return curr;
    }

    public int readNext(int offset, boolean ignoreComments) throws CoreException {
        this.setOffset(offset);
        return this.readNext(ignoreComments);
    }

    public int getNextStartOffset(int offset, boolean ignoreComments) throws CoreException {
        this.readNext(offset, ignoreComments);
        return this.getCurrentStartOffset();
    }

    public int getNextEndOffset(int offset, boolean ignoreComments) throws CoreException {
        this.readNext(offset, ignoreComments);
        return this.getCurrentEndOffset();
    }

    public void readToToken(int tok) throws CoreException {
        int curr = 0;
        while ((curr = this.readNext(false)) != tok) {
        }
    }

    public void readToToken(int tok, int offset) throws CoreException {
        this.setOffset(offset);
        this.readToToken(tok);
    }

    public int getTokenStartOffset(int token, int startOffset) throws CoreException {
        this.readToToken(token, startOffset);
        return this.getCurrentStartOffset();
    }

    public int getTokenEndOffset(int token, int startOffset) throws CoreException {
        this.readToToken(token, startOffset);
        return this.getCurrentEndOffset();
    }

    public int getPreviousTokenEndOffset(int token, int startOffset) throws CoreException {
        this.setOffset(startOffset);
        int res = startOffset;
        int curr = this.readNext(false);
        while (curr != token) {
            res = this.getCurrentEndOffset();
            curr = this.readNext(false);
        }
        return res;
    }

    public int getTokenCommentStart(int lastPos, int nodeStart) throws CoreException {
        this.setOffset(lastPos);
        int prevEndPos = lastPos;
        int prevEndLine = prevEndPos > 0 ? this.getLineOfOffset(prevEndPos - 1) : 0;
        int nodeLine = this.getLineOfOffset(nodeStart);
        int res = -1;
        int curr = this.readNextWithEOF(false);
        int currStartPos = this.getCurrentStartOffset();
        int currStartLine = this.getLineOfOffset(currStartPos);
        while (curr != 1000 && nodeStart > currStartPos) {
            if (TokenScanner.isComment(curr)) {
                int linesDifference = currStartLine - prevEndLine;
                if (linesDifference > 1 || res == -1 && (linesDifference != 0 || nodeLine == currStartLine)) {
                    res = currStartPos;
                }
            } else {
                res = -1;
            }
            prevEndLine = curr == 1003 ? currStartLine : this.getLineOfOffset(this.getCurrentEndOffset() - 1);
            curr = this.readNextWithEOF(false);
            currStartPos = this.getCurrentStartOffset();
            currStartLine = this.getLineOfOffset(currStartPos);
        }
        if (res == -1 || curr == 1000) {
            return nodeStart;
        }
        if (currStartLine - prevEndLine > 1) {
            return nodeStart;
        }
        return res;
    }

    public int getTokenCommentEnd(int nodeEnd, int nextTokenStart) throws CoreException {
        int linesDifference;
        int currStartLine;
        int prevEndLine = this.getLineOfOffset(nodeEnd - 1);
        int prevEndPos = nodeEnd;
        int res = nodeEnd;
        boolean sameLineComment = true;
        this.setOffset(nodeEnd);
        int curr = this.readNextWithEOF(false);
        while (curr == 1003 || curr == 1004) {
            currStartLine = this.getLineOfOffset(this.getCurrentStartOffset());
            linesDifference = currStartLine - prevEndLine;
            if (linesDifference > 1) {
                return prevEndPos;
            }
            if (curr == 1003) {
                prevEndPos = this.getLineEnd(currStartLine);
                prevEndLine = currStartLine;
            } else {
                prevEndPos = this.getCurrentEndOffset();
                prevEndLine = this.getLineOfOffset(prevEndPos - 1);
            }
            if (sameLineComment) {
                if (linesDifference == 0) {
                    res = prevEndPos;
                } else {
                    sameLineComment = false;
                }
            }
            curr = this.readNextWithEOF(false);
        }
        if (curr == 1000) {
            return prevEndPos;
        }
        currStartLine = this.getLineOfOffset(this.getCurrentStartOffset());
        linesDifference = currStartLine - prevEndLine;
        if (linesDifference > 1) {
            return prevEndPos;
        }
        return res;
    }

    private int getLineOfOffset(int offset) throws CoreException {
        if (this.fDocument != null) {
            try {
                return this.fDocument.getLineOfOffset(offset);
            }
            catch (BadLocationException e) {
                String message = "Illegal offset: " + offset;
                throw new CoreException(this.createError(20003, message, e));
            }
        }
        return this.getScanner().getLineNumber(offset);
    }

    private int getLineEnd(int line) throws CoreException {
        if (this.fDocument != null) {
            try {
                IRegion region = this.fDocument.getLineInformation(line);
                return region.getOffset() + region.getLength();
            }
            catch (BadLocationException e) {
                String message = "Illegal line: " + line;
                throw new CoreException(this.createError(20003, message, e));
            }
        }
        return this.getScanner().getLineEnd(line);
    }

    public static boolean isComment(int token) {
        return token == 1004 || token == 1003;
    }

    private IStatus createError(int code, String message, Throwable e) {
        return AsnUIStatus.createError(20003, message, e);
    }
}

