/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.viewsupport.AsnUILabelProvider;
import org.asnlab.asndt.internal.ui.viewsupport.IProblemChangedListener;
import org.asnlab.asndt.ui.ProblemsLabelDecorator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class AsnEditorErrorTickUpdater
implements IProblemChangedListener {
    private AsnEditor fAsnEditor;
    private AsnUILabelProvider fLabelProvider;

    public AsnEditorErrorTickUpdater(AsnEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fAsnEditor = editor;
        this.fLabelProvider = new AsnUILabelProvider();
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        AsnPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    @Override
    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        IAsnElement jelement;
        if (!isMarkerChange) {
            return;
        }
        IEditorInput input = this.fAsnEditor.getEditorInput();
        if (input != null && (jelement = (IAsnElement)input.getAdapter(IAsnElement.class)) != null) {
            IResource resource = jelement.getResource();
            int i = 0;
            while (i < changedResources.length) {
                if (changedResources[i].equals((Object)resource)) {
                    this.updateEditorImage(jelement);
                }
                ++i;
            }
        }
    }

    public void updateEditorImage(IAsnElement aelement) {
        Image titleImage = this.fAsnEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = aelement instanceof ICompilationUnit && !aelement.getAsnProject().isOnBuildPath(aelement) ? this.fLabelProvider.getImage(aelement.getResource()) : this.fLabelProvider.getImage(aelement);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.fAsnEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AsnEditorErrorTickUpdater.this.fAsnEditor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        AsnPlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }
}

