/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IMember;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.core.dom.CompilationUnitDeclaration;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.actions.AddBlockCommentAction;
import org.asnlab.asndt.internal.ui.actions.CompositeActionGroup;
import org.asnlab.asndt.internal.ui.actions.IndentAction;
import org.asnlab.asndt.internal.ui.actions.RemoveBlockCommentAction;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditorErrorTickUpdater;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditorMessages;
import org.asnlab.asndt.internal.ui.asneditor.AsnMoveLinesAction;
import org.asnlab.asndt.internal.ui.asneditor.AsnSourceViewer;
import org.asnlab.asndt.internal.ui.asneditor.ICompilationUnitDocumentProvider;
import org.asnlab.asndt.internal.ui.asneditor.ISavePolicy;
import org.asnlab.asndt.internal.ui.asneditor.ToggleCommentAction;
import org.asnlab.asndt.internal.ui.asneditor.WorkingCopyManager;
import org.asnlab.asndt.internal.ui.text.AsnHeuristicScanner;
import org.asnlab.asndt.internal.ui.text.ContentAssistPreference;
import org.asnlab.asndt.internal.ui.text.SmartBackspaceManager;
import org.asnlab.asndt.internal.ui.text.asn.IAsnReconcilingListener;
import org.asnlab.asndt.ui.actions.GenerateActionGroup;
import org.asnlab.asndt.ui.actions.RefactorActionGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class CompilationUnitEditor
extends AsnEditor
implements IAsnReconcilingListener {
    private static final boolean CODE_ASSIST_DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.asnlab.asndt.ui/debug/ResultCollector"));
    public static final int CONTENTASSIST_COMPLETE_PREFIX = 60;
    private static final String CODE_FORMATTER_TAB_SIZE = "org.asnlab.asndt.core.formatter.tabulation.size";
    private static final String SPACES_FOR_TABS = "org.asnlab.asndt.core.formatter.tabulation.char";
    private static final String CLOSE_STRINGS = "closeStrings";
    private static final String CLOSE_BRACKETS = "closeBrackets";
    protected ISavePolicy fSavePolicy;
    private AsnEditorErrorTickUpdater fAsnEditorErrorTickUpdater;
    private TabConverter fTabConverter;
    private RememberedSelection fRememberedSelection = new RememberedSelection();
    private BracketInserter fBracketInserter = new BracketInserter();
    private GenerateActionGroup fGenerateActionGroup;
    private CompositeActionGroup fContextMenuGroup;
    private ListenerList fReconcilingListeners = new ListenerList(1);
    private final Object fReconcilerLock = new Object();

    public CompilationUnitEditor() {
        this.setDocumentProvider(AsnPlugin.getDefault().getCompilationUnitDocumentProvider());
        this.setEditorContextMenuId("#ASNEditorContext");
        this.setRulerContextMenuId("#ASNRulerContext");
        this.setOutlinerContextMenuId("#ASNOutlinerContext");
        this.fSavePolicy = null;
        this.fAsnEditorErrorTickUpdater = new AsnEditorErrorTickUpdater(this);
    }

    @Override
    protected void createActions() {
        super.createActions();
        Object action = new ContentAssistAction(AsnEditorMessages.getBundleForConstructedKeys(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.content_assist_action");
        action = new TextOperationAction(AsnEditorMessages.getBundleForConstructedKeys(), "ContentAssistContextInformation.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.parameter_hints_action");
        action = new TextOperationAction(AsnEditorMessages.getBundleForConstructedKeys(), "Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.comment");
        this.setAction("Comment", (IAction)action);
        this.markAsStateDependentAction("Comment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.comment_action");
        action = new TextOperationAction(AsnEditorMessages.getBundleForConstructedKeys(), "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.uncomment");
        this.setAction("Uncomment", (IAction)action);
        this.markAsStateDependentAction("Uncomment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.uncomment_action");
        action = new ToggleCommentAction(AsnEditorMessages.getBundleForConstructedKeys(), "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.toggle.comment");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.toggle_comment_action");
        this.configureToggleCommentAction();
        action = new TextOperationAction(AsnEditorMessages.getBundleForConstructedKeys(), "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.format");
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        this.markAsSelectionDependentAction("Format", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.format_action");
        action = new AddBlockCommentAction(AsnEditorMessages.getBundleForConstructedKeys(), "AddBlockComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.add.block.comment");
        this.setAction("AddBlockComment", (IAction)action);
        this.markAsStateDependentAction("AddBlockComment", true);
        this.markAsSelectionDependentAction("AddBlockComment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.add_block_comment_action");
        action = new RemoveBlockCommentAction(AsnEditorMessages.getBundleForConstructedKeys(), "RemoveBlockComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.remove.block.comment");
        this.setAction("RemoveBlockComment", (IAction)action);
        this.markAsStateDependentAction("RemoveBlockComment", true);
        this.markAsSelectionDependentAction("RemoveBlockComment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.remove_block_comment_action");
        action = new IndentAction(AsnEditorMessages.getBundleForConstructedKeys(), "Indent.", (ITextEditor)this, false);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.indent");
        this.setAction("Indent", (IAction)action);
        this.markAsStateDependentAction("Indent", true);
        this.markAsSelectionDependentAction("Indent", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.indent_action");
        action = new IndentAction(AsnEditorMessages.getBundleForConstructedKeys(), "Indent.", (ITextEditor)this, true);
        this.setAction("IndentOnTab", (IAction)action);
        this.markAsStateDependentAction("IndentOnTab", true);
        this.markAsSelectionDependentAction("IndentOnTab", true);
        AsnMoveLinesAction[] moveLinesActions = AsnMoveLinesAction.createMoveCopyActionSet(AsnEditorMessages.getBundleForConstructedKeys(), this);
        AsnMoveLinesAction rAction = moveLinesActions[0];
        rAction.setHelpContextId("org.eclipse.ui.move_lines_action_context");
        rAction.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineUp");
        this.setAction("MoveLineUp", (IAction)rAction);
        rAction = moveLinesActions[1];
        rAction.setHelpContextId("org.eclipse.ui.move_lines_action_context");
        rAction.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineDown");
        this.setAction("MoveLineDown", (IAction)rAction);
        rAction = moveLinesActions[2];
        rAction.setHelpContextId("org.eclipse.ui.copy_lines_action_context");
        rAction.setActionDefinitionId("org.eclipse.ui.edit.text.copyLineUp");
        this.setAction("CopyLineUp", (IAction)rAction);
        rAction = moveLinesActions[3];
        rAction.setHelpContextId("org.eclipse.ui.copy_lines_action_context");
        rAction.setActionDefinitionId("org.eclipse.ui.edit.text.copyLineDown");
        this.setAction("CopyLineDown", (IAction)rAction);
        if (this.getPreferenceStore().getBoolean("smart_tab")) {
            this.removeActionActivationCode("ShiftRight");
            this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
        }
        this.fGenerateActionGroup = new GenerateActionGroup(this, "group.edit");
        RefactorActionGroup rg = new RefactorActionGroup(this, "group.edit");
        this.fActionGroups.addGroup(rg);
        this.fActionGroups.addGroup(this.fGenerateActionGroup);
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{this.fGenerateActionGroup, rg});
    }

    @Override
    protected IAsnElement getElementAt(int offset) {
        return this.getElementAt(offset, true);
    }

    @Override
    protected IAsnElement getElementAt(int offset, boolean reconcile) {
        block5: {
            ICompilationUnit unit = (ICompilationUnit)this.getInputAsnElement();
            if (unit != null) {
                try {
                    if (reconcile) {
                        AsnModelUtil.reconcile(unit);
                        return unit.getElementAt(offset);
                    }
                    if (unit.isConsistent()) {
                        return unit.getElementAt(offset);
                    }
                }
                catch (AsnModelException x) {
                    if (x.isDoesNotExist()) break block5;
                    AsnPlugin.log(x.getStatus());
                }
            }
        }
        return null;
    }

    @Override
    protected IAsnElement getCorrespondingElement(IAsnElement element) {
        return element;
    }

    @Override
    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p instanceof ICompilationUnitDocumentProvider) {
            ICompilationUnitDocumentProvider cp = (ICompilationUnitDocumentProvider)p;
            cp.setSavePolicy(this.fSavePolicy);
        }
        try {
            super.performSave(overwrite, progressMonitor);
        }
        finally {
            if (p instanceof ICompilationUnitDocumentProvider) {
                ICompilationUnitDocumentProvider cp = (ICompilationUnitDocumentProvider)p;
                cp.setSavePolicy(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                MessageDialog.openError((Shell)shell, (String)AsnEditorMessages.CompilationUnitEditor_error_saving_title1, (String)AsnEditorMessages.CompilationUnitEditor_error_saving_message1);
            }
        } else {
            this.setStatusLineErrorMessage(null);
            this.updateState(this.getEditorInput());
            this.validateState(this.getEditorInput());
            WorkingCopyManager manager = AsnPlugin.getDefault().getWorkingCopyManager();
            ICompilationUnit unit = manager.getWorkingCopy(this.getEditorInput());
            if (unit != null) {
                ICompilationUnit iCompilationUnit = unit;
                synchronized (iCompilationUnit) {
                    this.performSave(false, progressMonitor);
                }
            } else {
                this.performSave(false, progressMonitor);
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        String key = this.getEditorSite().getId() + ".internal.delegateSaveAs";
        store.setValue(key, true);
        super.performSaveAs(progressMonitor);
    }

    @Override
    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.configureTabConverter();
        this.configureToggleCommentAction();
        if (this.fAsnEditorErrorTickUpdater != null) {
            this.fAsnEditorErrorTickUpdater.updateEditorImage(this.getInputAsnElement());
        }
    }

    private void configureToggleCommentAction() {
        IAction action = this.getAction("ToggleComment");
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    private void configureTabConverter() {
        IDocumentProvider provider;
        if (this.fTabConverter != null && (provider = this.getDocumentProvider()) instanceof ICompilationUnitDocumentProvider) {
            ICompilationUnitDocumentProvider cup = (ICompilationUnitDocumentProvider)provider;
            this.fTabConverter.setLineTracker(cup.createLineTracker(this.getEditorInput()));
        }
    }

    private int getTabSize() {
        IAsnElement element = this.getInputAsnElement();
        if (element != null) {
            element.getAsnProject();
        }
        return 1;
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.configureTabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getTabSize());
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            asv.addTextConverter(this.fTabConverter);
            asv.updateIndentationPrefixes();
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            asv.removeTextConverter(this.fTabConverter);
            asv.updateIndentationPrefixes();
            this.fTabConverter = null;
        }
    }

    private boolean isTabConversionEnabled() {
        IAsnElement element = this.getInputAsnElement();
        IAsnProject project = element == null ? null : element.getAsnProject();
        String option = project == null ? AsnCore.getOption((String)SPACES_FOR_TABS) : project.getOption(SPACES_FOR_TABS, true);
        return "space".equals(option);
    }

    @Override
    public void dispose() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        if (this.fAsnEditorErrorTickUpdater != null) {
            this.fAsnEditorErrorTickUpdater.dispose();
            this.fAsnEditorErrorTickUpdater = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
            this.fActionGroups = null;
        }
        super.dispose();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean closeBrackets = preferenceStore.getBoolean(CLOSE_BRACKETS);
        boolean closeStrings = preferenceStore.getBoolean(CLOSE_STRINGS);
        this.fBracketInserter.setCloseBracketsEnabled(closeBrackets);
        this.fBracketInserter.setCloseStringsEnabled(closeStrings);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '<': {
                return '>';
            }
            case '>': {
                return '<';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            if (asv != null) {
                IContentAssistant c;
                String p = event.getProperty();
                if (CLOSE_BRACKETS.equals(p)) {
                    this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(p));
                    return;
                }
                if (CLOSE_STRINGS.equals(p)) {
                    this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(p));
                    return;
                }
                if (SPACES_FOR_TABS.equals(p)) {
                    if (this.isTabConversionEnabled()) {
                        this.startTabConversion();
                    } else {
                        this.stopTabConversion();
                    }
                    return;
                }
                if ("smart_tab".equals(p)) {
                    if (this.getPreferenceStore().getBoolean("smart_tab")) {
                        this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
                    } else {
                        this.removeActionActivationCode("IndentOnTab");
                    }
                }
                if ((c = asv.getContentAssistant()) instanceof ContentAssistant) {
                    ContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
                }
                if (CODE_FORMATTER_TAB_SIZE.equals(p)) {
                    asv.updateIndentationPrefixes();
                    if (this.fTabConverter != null) {
                        this.fTabConverter.setNumberOfSpacesPerTab(this.getTabSize());
                    }
                }
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    @Override
    protected ISourceViewer createAsnSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles, IPreferenceStore store) {
        return new AdaptedSourceViewer(parent, verticalRuler, overviewRuler, isOverviewRulerVisible, styles, store);
    }

    @Override
    public void aboutToBeReconciled() {
        AsnPlugin.getDefault().getASTProvider().aboutToBeReconciled(this.getInputAsnElement());
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IAsnReconcilingListener)listeners[i]).aboutToBeReconciled();
            ++i;
        }
    }

    @Override
    public void reconciled(CompilationUnitDeclaration ast, boolean forced, IProgressMonitor progressMonitor) {
        Shell shell;
        AsnPlugin asnPlugin = AsnPlugin.getDefault();
        if (asnPlugin == null) {
            return;
        }
        asnPlugin.getASTProvider().reconciled(ast, this.getInputAsnElement(), progressMonitor);
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IAsnReconcilingListener)listeners[i]).reconciled(ast, forced, progressMonitor);
            ++i;
        }
        if (!(forced || progressMonitor.isCanceled() || (shell = this.getSite().getShell()) == null || shell.isDisposed())) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CompilationUnitEditor.this.selectionChanged();
                }
            });
        }
    }

    protected final boolean isActiveEditor() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return false;
        }
        IEditorPart activeEditor = page.getActiveEditor();
        return activeEditor != null && activeEditor.equals(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addReconcileListener(IAsnReconcilingListener listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeReconcileListener(IAsnReconcilingListener listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.remove((Object)listener);
        }
    }

    protected void updateStateDependentActions() {
        super.updateStateDependentActions();
        this.fGenerateActionGroup.editorStateChanged();
    }

    protected void rememberSelection() {
        this.fRememberedSelection.remember();
    }

    protected void restoreSelection() {
        this.fRememberedSelection.restore();
    }

    protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
        IFile file;
        String ext;
        IFile file2;
        String oldExtension = "";
        if (originalElement instanceof IFileEditorInput && (file2 = ((IFileEditorInput)originalElement).getFile()) != null && (ext = file2.getFileExtension()) != null) {
            oldExtension = ext;
        }
        String newExtension = "";
        if (movedElement instanceof IFileEditorInput && (file = ((IFileEditorInput)movedElement).getFile()) != null) {
            newExtension = file.getFileExtension();
        }
        return oldExtension.equals(newExtension);
    }

    @Override
    protected boolean isPrefQuickDiffAlwaysOn() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("quickdiff.quickDiff");
    }

    @Override
    public Object getAdapter(Class required) {
        if (SmartBackspaceManager.class.equals((Object)required) && this.getSourceViewer() instanceof AsnSourceViewer) {
            return ((AsnSourceViewer)this.getSourceViewer()).getBackspaceManager();
        }
        return super.getAdapter(required);
    }

    public Object getReconcilerLock() {
        return this.fReconcilerLock;
    }

    @Override
    protected void createNavigationActions() {
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        TextNavigationAction action = new AsnEditor.DeletePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deletePreviousWord");
        this.setAction("org.eclipse.ui.edit.text.deletePreviousWord", (IAction)action);
        textWidget.setKeyBinding(262152, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deletePreviousWord", true);
        action = new AsnEditor.DeleteNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deleteNextWord");
        this.setAction("org.eclipse.ui.edit.text.deleteNextWord", (IAction)action);
        textWidget.setKeyBinding(262271, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deleteNextWord", true);
    }

    class AdaptedSourceViewer
    extends AsnSourceViewer {
        private List fTextConverters;
        private boolean fIgnoreTextConverters;

        public AdaptedSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles, store);
            this.fIgnoreTextConverters = false;
        }

        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }

        @Override
        public void doOperation(int operation) {
            if (this.getTextWidget() == null) {
                return;
            }
            switch (operation) {
                case 13: {
                    long time = CODE_ASSIST_DEBUG ? System.currentTimeMillis() : 0L;
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    if (CODE_ASSIST_DEBUG) {
                        long delta = System.currentTimeMillis() - time;
                        System.err.println("Code Assist (total): " + delta);
                    }
                    CompilationUnitEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 22: {
                    String msg = this.fQuickAssistAssistant.showPossibleQuickAssists();
                    CompilationUnitEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 1: {
                    this.fIgnoreTextConverters = true;
                    super.doOperation(operation);
                    this.fIgnoreTextConverters = false;
                    return;
                }
                case 2: {
                    this.fIgnoreTextConverters = true;
                    super.doOperation(operation);
                    this.fIgnoreTextConverters = false;
                    return;
                }
            }
            super.doOperation(operation);
        }

        public void insertTextConverter(ITextConverter textConverter, int index) {
            throw new UnsupportedOperationException();
        }

        public void addTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters == null) {
                this.fTextConverters = new ArrayList(1);
                this.fTextConverters.add(textConverter);
            } else if (!this.fTextConverters.contains(textConverter)) {
                this.fTextConverters.add(textConverter);
            }
        }

        public void removeTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters != null) {
                this.fTextConverters.remove(textConverter);
                if (this.fTextConverters.size() == 0) {
                    this.fTextConverters = null;
                }
            }
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (!this.fIgnoreTextConverters && this.fTextConverters != null) {
                Iterator e = this.fTextConverters.iterator();
                while (e.hasNext()) {
                    ((ITextConverter)e.next()).customizeDocumentCommand(this.getDocument(), command);
                }
            }
        }

        public void updateIndentationPrefixes() {
            SourceViewerConfiguration configuration = CompilationUnitEditor.this.getSourceViewerConfiguration();
            String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
            int i = 0;
            while (i < types.length) {
                String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, types[i]);
                if (prefixes != null && prefixes.length > 0) {
                    this.setIndentPrefixes(prefixes, types[i]);
                }
                ++i;
            }
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester);
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester, priority);
        }
    }

    private class BracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;
        private final String CATEGORY = this.toString();
        private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
        private Stack fBracketLevelStack = new Stack();

        private BracketInserter() {
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || CompilationUnitEditor.this.getInsertMode() != SMART_INSERT) {
                return;
            }
            switch (event.character) {
                case '\"': 
                case '\'': 
                case '(': 
                case '[': {
                    break;
                }
                default: {
                    return;
                }
            }
            ISourceViewer sourceViewer = CompilationUnitEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            try {
                ITypedRegion partition;
                IRegion startLine = document.getLineInformationOfOffset(offset);
                IRegion endLine = document.getLineInformationOfOffset(offset + length);
                AsnHeuristicScanner scanner = new AsnHeuristicScanner(document);
                int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
                String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
                int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
                switch (event.character) {
                    case '(': {
                        if (this.fCloseBrackets && nextToken != 5 && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '[': {
                        if (this.fCloseBrackets && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '\'': {
                        if (this.fCloseStrings && nextToken != 2000 && prevToken != 16 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '\"': {
                        if (this.fCloseStrings && nextToken != 2000 && prevToken != 15 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                if (!"__dftl_partition_content_type".equals((partition = TextUtilities.getPartition((IDocument)document, (String)"___asn_partitioning", (int)offset, (boolean)true)).getType())) {
                    return;
                }
                if (!CompilationUnitEditor.this.validateEditorInputState()) {
                    return;
                }
                char character = event.character;
                char closingCharacter = CompilationUnitEditor.getPeerCharacter(character);
                StringBuffer buffer = new StringBuffer();
                buffer.append(character);
                buffer.append(closingCharacter);
                document.replace(offset, length, buffer.toString());
                BracketLevel level = new BracketLevel();
                this.fBracketLevelStack.push(level);
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addLinkingListener((ILinkedModeListener)this);
                model.addGroup(group);
                model.forceInstall();
                level.fOffset = offset;
                level.fLength = 2;
                if (this.fBracketLevelStack.size() == 1) {
                    document.addPositionCategory(this.CATEGORY);
                    document.addPositionUpdater(this.fUpdater);
                }
                level.fFirstPosition = new Position(offset, 1);
                level.fSecondPosition = new Position(offset + 1, 1);
                document.addPosition(this.CATEGORY, level.fFirstPosition);
                document.addPosition(this.CATEGORY, level.fSecondPosition);
                level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
                level.fUI.setSimpleMode(true);
                level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, CompilationUnitEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
                level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                level.fUI.enter();
                IRegion newSelection = level.fUI.getSelectedRegion();
                sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                event.doit = false;
            }
            catch (BadLocationException e) {
                AsnPlugin.log(e);
            }
            catch (BadPositionCategoryException e) {
                AsnPlugin.log(e);
            }
        }

        public void left(LinkedModeModel environment, int flags) {
            final BracketLevel level = (BracketLevel)this.fBracketLevelStack.pop();
            if (flags != 8) {
                return;
            }
            ISourceViewer sourceViewer = CompilationUnitEditor.this.getSourceViewer();
            final IDocument document = sourceViewer.getDocument();
            if (document instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)document;
                extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                    public void perform(IDocument d, IDocumentListener owner) {
                        if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                            try {
                                document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, null);
                            }
                            catch (BadLocationException e) {
                                AsnPlugin.log(e);
                            }
                        }
                        if (BracketInserter.this.fBracketLevelStack.size() == 0) {
                            document.removePositionUpdater(BracketInserter.this.fUpdater);
                            try {
                                document.removePositionCategory(BracketInserter.this.CATEGORY);
                            }
                            catch (BadPositionCategoryException e) {
                                AsnPlugin.log(e);
                            }
                        }
                    }
                });
            }
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void resume(LinkedModeModel environment, int flags) {
        }
    }

    private static class BracketLevel {
        int fOffset;
        int fLength;
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        private BracketLevel() {
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        public String getCategory() {
            return this.fCategory;
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack fStack;
        final int fSize;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                if (event.character == this.fExitCharacter) {
                    BracketLevel level = (BracketLevel)this.fStack.peek();
                    if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                        return null;
                    }
                    if (level.fSecondPosition.offset == offset && length == 0) {
                        return new LinkedModeUI.ExitFlags(2, false);
                    }
                }
                if (event.character == '\r' && offset > 0) {
                    IDocument document = CompilationUnitEditor.this.getSourceViewer().getDocument();
                    try {
                        if (document.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = CompilationUnitEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    private class RememberedOffset {
        private int fLine;
        private int fColumn;
        private IAsnElement fElement;
        private int fElementLine;

        private RememberedOffset() {
        }

        public void setOffset(int offset) {
            try {
                IDocument document = CompilationUnitEditor.this.getSourceViewer().getDocument();
                this.fLine = document.getLineOfOffset(offset);
                this.fColumn = offset - document.getLineOffset(this.fLine);
                this.fElement = CompilationUnitEditor.this.getElementAt(offset, true);
                this.fElementLine = this.getElementLine(document, this.fElement);
            }
            catch (BadLocationException e) {
                AsnPlugin.log(e);
                this.clear();
            }
            catch (AsnModelException e) {
                AsnPlugin.log(e.getStatus());
                this.clear();
            }
        }

        private int getElementLine(IDocument document, IAsnElement element) throws BadLocationException, AsnModelException {
            ISourceRange range;
            if (element instanceof IMember && (range = ((IMember)element).getNameRange()) != null) {
                return document.getLineOfOffset(range.getOffset());
            }
            int elementOffset = this.getOffset(element);
            if (elementOffset != -1) {
                return document.getLineOfOffset(elementOffset);
            }
            return -1;
        }

        public int getOffset() {
            IAsnElement newElement = this.getElement();
            int offset = this.getRememberedOffset(newElement);
            if (offset == -1 || newElement != null && !this.containsOffset(newElement, offset) && (offset == 0 || !this.containsOffset(newElement, offset - 1))) {
                return -1;
            }
            return offset;
        }

        public int getRememberedOffset(IAsnElement newElement) {
            int newLine;
            IDocument document;
            block6: {
                document = CompilationUnitEditor.this.getSourceViewer().getDocument();
                int newElementLine = this.getElementLine(document, newElement);
                newLine = this.fLine;
                if (newElementLine != -1 && this.fElementLine != -1) {
                    newLine += newElementLine - this.fElementLine;
                }
                if (newLine >= 0 && newLine < document.getNumberOfLines()) break block6;
                return -1;
            }
            try {
                int maxColumn = document.getLineLength(newLine);
                String lineDelimiter = document.getLineDelimiter(newLine);
                if (lineDelimiter != null) {
                    maxColumn -= lineDelimiter.length();
                }
                int offset = this.fColumn > maxColumn ? document.getLineOffset(newLine) + maxColumn : document.getLineOffset(newLine) + this.fColumn;
                return offset;
            }
            catch (BadLocationException e) {
                AsnPlugin.log(e);
                return -1;
            }
            catch (AsnModelException e) {
                AsnPlugin.log(e.getStatus());
                return -1;
            }
        }

        public int getRevealOffset(IAsnElement element, int offset) {
            if (element == null || offset == -1) {
                return -1;
            }
            if (this.containsOffset(element, offset)) {
                IAsnElement alternateElement;
                if (offset > 0 && element.equals((alternateElement = CompilationUnitEditor.this.getElementAt(offset, false)).getParent())) {
                    return offset - 1;
                }
                return offset;
            }
            if (offset > 0 && this.containsOffset(element, offset - 1)) {
                return offset - 1;
            }
            return -1;
        }

        public IAsnElement getElement() {
            if (this.fElement == null) {
                return null;
            }
            return this.findElement(this.fElement);
        }

        public void clear() {
            this.fLine = -1;
            this.fColumn = -1;
            this.fElement = null;
            this.fElementLine = -1;
        }

        private boolean containsOffset(IAsnElement element, int offset) {
            int elementOffset = this.getOffset(element);
            int elementLength = this.getLength(element);
            return elementOffset > -1 && elementLength > -1 ? offset >= elementOffset && offset < elementOffset + elementLength : false;
        }

        private int getOffset(IAsnElement element) {
            if (element instanceof ISourceReference) {
                ISourceReference sr = (ISourceReference)element;
                try {
                    ISourceRange srcRange = sr.getSourceRange();
                    if (srcRange != null) {
                        return srcRange.getOffset();
                    }
                }
                catch (AsnModelException asnModelException) {}
            }
            return -1;
        }

        private int getLength(IAsnElement element) {
            if (element instanceof ISourceReference) {
                ISourceReference sr = (ISourceReference)element;
                try {
                    ISourceRange srcRange = sr.getSourceRange();
                    if (srcRange != null) {
                        return srcRange.getLength();
                    }
                }
                catch (AsnModelException asnModelException) {}
            }
            return -1;
        }

        private IAsnElement findElement(IAsnElement element) {
            if (element == null) {
                return null;
            }
            WorkingCopyManager manager = AsnPlugin.getDefault().getWorkingCopyManager();
            ICompilationUnit unit = manager.getWorkingCopy(CompilationUnitEditor.this.getEditorInput());
            if (unit != null) {
                try {
                    AsnModelUtil.reconcile(unit);
                    IAsnElement[] findings = unit.findElements(element);
                    if (findings != null && findings.length > 0) {
                        return findings[0];
                    }
                }
                catch (AsnModelException x) {
                    AsnPlugin.log(x.getStatus());
                }
            }
            return null;
        }
    }

    private class RememberedSelection {
        private RememberedOffset fStartOffset;
        private RememberedOffset fEndOffset;

        private RememberedSelection() {
            this.fStartOffset = new RememberedOffset();
            this.fEndOffset = new RememberedOffset();
        }

        public void remember() {
            ISourceViewer viewer = CompilationUnitEditor.this.getSourceViewer();
            if (viewer != null) {
                IRegion selection = CompilationUnitEditor.this.getSignedSelection(viewer);
                int startOffset = selection.getOffset();
                int endOffset = startOffset + selection.getLength();
                this.fStartOffset.setOffset(startOffset);
                this.fEndOffset.setOffset(endOffset);
            }
        }

        public void restore() {
            if (CompilationUnitEditor.this.getSourceViewer() == null) {
                return;
            }
            try {
                int endOffset;
                int revealEndOffset;
                int revealStartOffset;
                int startOffset;
                if (CompilationUnitEditor.this.showsHighlightRangeOnly()) {
                    IAsnElement newEndElement;
                    IAsnElement newStartElement = this.fStartOffset.getElement();
                    revealStartOffset = this.fStartOffset.getRevealOffset(newStartElement, startOffset = this.fStartOffset.getRememberedOffset(newStartElement));
                    if (revealStartOffset == -1) {
                        startOffset = -1;
                    }
                    if ((revealEndOffset = this.fEndOffset.getRevealOffset(newEndElement = this.fEndOffset.getElement(), endOffset = this.fEndOffset.getRememberedOffset(newEndElement))) == -1) {
                        endOffset = -1;
                    }
                } else {
                    revealStartOffset = startOffset = this.fStartOffset.getOffset();
                    revealEndOffset = endOffset = this.fEndOffset.getOffset();
                }
                if (startOffset == -1) {
                    startOffset = endOffset;
                    revealStartOffset = revealEndOffset;
                }
                if (endOffset == -1) {
                    endOffset = startOffset;
                    revealEndOffset = revealStartOffset;
                }
                if (endOffset == -1) {
                    IAsnElement element = this.fEndOffset.getElement();
                    if (element == null) {
                        element = this.fStartOffset.getElement();
                    }
                    if (element != null) {
                        CompilationUnitEditor.this.setSelection(element);
                    }
                    return;
                }
                if (this.isValidSelection(revealStartOffset, revealEndOffset - revealStartOffset) && this.isValidSelection(startOffset, endOffset - startOffset)) {
                    CompilationUnitEditor.this.selectAndReveal(startOffset, endOffset - startOffset, revealStartOffset, revealEndOffset - revealStartOffset);
                }
            }
            finally {
                this.fStartOffset.clear();
                this.fEndOffset.clear();
            }
        }

        private boolean isValidSelection(int offset, int length) {
            IDocument document;
            IDocumentProvider provider = CompilationUnitEditor.this.getDocumentProvider();
            if (provider != null && (document = provider.getDocument((Object)CompilationUnitEditor.this.getEditorInput())) != null) {
                int end = offset + length;
                int documentLength = document.getLength();
                return offset >= 0 && offset <= documentLength && end >= 0 && end <= documentLength;
            }
            return false;
        }
    }

    static class TabConverter
    implements ITextConverter {
        private int fTabRatio;
        private ILineTracker fLineTracker;

        public void setNumberOfSpacesPerTab(int ratio) {
            this.fTabRatio = ratio;
        }

        public void setLineTracker(ILineTracker lineTracker) {
            this.fLineTracker = lineTracker;
        }

        private int insertTabString(StringBuffer buffer, int offsetInLine) {
            if (this.fTabRatio == 0) {
                return 0;
            }
            int remainder = offsetInLine % this.fTabRatio;
            remainder = this.fTabRatio - remainder;
            int i = 0;
            while (i < remainder) {
                buffer.append(' ');
                ++i;
            }
            return remainder;
        }

        @Override
        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            if (text == null) {
                return;
            }
            int index = text.indexOf(9);
            if (index > -1) {
                StringBuffer buffer = new StringBuffer();
                this.fLineTracker.set(command.text);
                int lines = this.fLineTracker.getNumberOfLines();
                try {
                    int i = 0;
                    while (i < lines) {
                        int offset = this.fLineTracker.getLineOffset(i);
                        int endOffset = offset + this.fLineTracker.getLineLength(i);
                        String line = text.substring(offset, endOffset);
                        int position = 0;
                        if (i == 0) {
                            IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                            position = command.offset - firstLine.getOffset();
                        }
                        int length = line.length();
                        int j = 0;
                        while (j < length) {
                            char c = line.charAt(j);
                            if (c == '\t') {
                                position += this.insertTabString(buffer, position);
                            } else {
                                buffer.append(c);
                                ++position;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    command.text = buffer.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }
}

