/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor.selectionactions;

import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.SelectionActionMessages;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.SelectionHistory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class StructureSelectHistoryAction
extends Action
implements IUpdate {
    private AsnEditor fEditor;
    private SelectionHistory fHistory;

    public StructureSelectHistoryAction(AsnEditor editor, SelectionHistory history) {
        super(SelectionActionMessages.StructureSelectHistory_label);
        this.setToolTipText(SelectionActionMessages.StructureSelectHistory_tooltip);
        this.setDescription(SelectionActionMessages.StructureSelectHistory_description);
        Assert.isNotNull((Object)history);
        Assert.isNotNull((Object)editor);
        this.fHistory = history;
        this.fEditor = editor;
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.structured_selection_history_action");
    }

    public void update() {
        this.setEnabled(!this.fHistory.isEmpty());
    }

    public void run() {
        ISourceRange old = this.fHistory.getLast();
        if (old != null) {
            try {
                this.fHistory.ignoreSelectionChanges();
                this.fEditor.selectAndReveal(old.getOffset(), old.getLength());
            }
            finally {
                this.fHistory.listenToSelectionChanges();
            }
        }
    }
}

