/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.asnlab.asndt.internal.ui.text.AbstractAsnScanner;
import org.asnlab.asndt.internal.ui.text.CombinedWordRule;
import org.asnlab.asndt.ui.text.IColorManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;

public class AsnCommentScanner
extends AbstractAsnScanner {
    private static final String COMPILER_TASK_TAGS = "org.asnlab.asndt.core.compiler.taskTags";
    private static final String COMPILER_TASK_CASE_SENSITIVE = "org.asnlab.asndt.core.compiler.taskCaseSensitive";
    private static final String ENABLED = "enabled";
    private TaskTagMatcher fTaskTagMatcher;
    private Preferences fCorePreferenceStore;
    private String fDefaultTokenProperty;
    private String[] fTokenProperties;

    public AsnCommentScanner(IColorManager manager, IPreferenceStore store, Preferences coreStore, String defaultTokenProperty) {
        this(manager, store, coreStore, defaultTokenProperty, new String[]{defaultTokenProperty});
    }

    public AsnCommentScanner(IColorManager manager, IPreferenceStore store, Preferences coreStore, String defaultTokenProperty, String[] tokenProperties) {
        super(manager, store);
        this.fCorePreferenceStore = coreStore;
        this.fDefaultTokenProperty = defaultTokenProperty;
        this.fTokenProperties = tokenProperties;
        this.initialize();
    }

    public AsnCommentScanner(IColorManager manager, IPreferenceStore store, String defaultTokenProperty) {
        this(manager, store, null, defaultTokenProperty, new String[]{defaultTokenProperty});
    }

    public AsnCommentScanner(IColorManager manager, IPreferenceStore store, String defaultTokenProperty, String[] tokenProperties) {
        this(manager, store, null, defaultTokenProperty, tokenProperties);
    }

    @Override
    protected List<IRule> createRules() {
        ArrayList<IRule> list = new ArrayList<IRule>();
        Token defaultToken = this.getToken(this.fDefaultTokenProperty);
        List matchers = this.createMatchers();
        if (matchers.size() > 0) {
            CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)new AtAsnIdentifierDetector(), (IToken)defaultToken);
            int i = 0;
            int n = matchers.size();
            while (i < n) {
                combinedWordRule.addWordMatcher((CombinedWordRule.WordMatcher)matchers.get(i));
                ++i;
            }
            list.add(combinedWordRule);
        }
        this.setDefaultReturnToken((IToken)defaultToken);
        return list;
    }

    protected List createMatchers() {
        ArrayList list = new ArrayList();
        if (this.getPreferenceStore().contains(COMPILER_TASK_TAGS)) {
            this.getPreferenceStore().getString(COMPILER_TASK_TAGS);
            ENABLED.equals(this.getPreferenceStore().getString(COMPILER_TASK_CASE_SENSITIVE));
        } else if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.getString(COMPILER_TASK_TAGS);
            ENABLED.equals(this.fCorePreferenceStore.getString(COMPILER_TASK_CASE_SENSITIVE));
        }
        return list;
    }

    @Override
    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals(COMPILER_TASK_TAGS) || event.getProperty().equals(COMPILER_TASK_CASE_SENSITIVE) || super.affectsBehavior(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fTaskTagMatcher != null && event.getProperty().equals(COMPILER_TASK_TAGS)) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                TaskTagMatcher taskTagMatcher = this.fTaskTagMatcher;
                synchronized (taskTagMatcher) {
                    this.fTaskTagMatcher.clearWords();
                    this.fTaskTagMatcher.addTaskTags((String)value);
                }
            }
        } else if (this.fTaskTagMatcher != null && event.getProperty().equals(COMPILER_TASK_CASE_SENSITIVE)) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                this.fTaskTagMatcher.setCaseSensitive(ENABLED.equals(value));
            }
        } else if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    @Override
    protected String[] getTokenProperties() {
        return this.fTokenProperties;
    }

    private static class AtAsnIdentifierDetector
    implements IWordDetector {
        private AtAsnIdentifierDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@' || Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }

    private class TaskTagMatcher
    extends CombinedWordRule.WordMatcher {
        private IToken fToken;
        private Map<CombinedWordRule.CharacterBuffer, IToken> fUppercaseWords = new HashMap<CombinedWordRule.CharacterBuffer, IToken>();
        private boolean fCaseSensitive = true;
        private CombinedWordRule.CharacterBuffer fBuffer = new CombinedWordRule.CharacterBuffer(16);

        public TaskTagMatcher(IToken token) {
            this.fToken = token;
        }

        @Override
        public synchronized void clearWords() {
            super.clearWords();
            this.fUppercaseWords.clear();
        }

        public synchronized void addTaskTags(String value) {
            String[] tasks = this.split(value, ",");
            int i = 0;
            while (i < tasks.length) {
                if (tasks[i].length() > 0) {
                    this.addWord(tasks[i], this.fToken);
                }
                ++i;
            }
        }

        private String[] split(String value, String delimiters) {
            StringTokenizer tokenizer = new StringTokenizer(value, delimiters);
            int size = tokenizer.countTokens();
            String[] tokens = new String[size];
            int i = 0;
            while (i < size) {
                tokens[i++] = tokenizer.nextToken();
            }
            return tokens;
        }

        @Override
        public synchronized void addWord(String word, IToken token) {
            Assert.isNotNull((Object)word);
            Assert.isNotNull((Object)token);
            super.addWord(word, token);
            this.fUppercaseWords.put(new CombinedWordRule.CharacterBuffer(word.toUpperCase()), token);
        }

        @Override
        public synchronized IToken evaluate(ICharacterScanner scanner, CombinedWordRule.CharacterBuffer word) {
            if (this.fCaseSensitive) {
                return super.evaluate(scanner, word);
            }
            this.fBuffer.clear();
            int i = 0;
            int n = word.length();
            while (i < n) {
                this.fBuffer.append(Character.toUpperCase(word.charAt(i)));
                ++i;
            }
            IToken token = this.fUppercaseWords.get(this.fBuffer);
            if (token != null) {
                return token;
            }
            return Token.UNDEFINED;
        }

        public boolean isCaseSensitive() {
            return this.fCaseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.fCaseSensitive = caseSensitive;
        }
    }
}

