/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text;

import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.text.CompositeReconcilingStrategy;
import org.asnlab.asndt.internal.ui.text.asn.AsnReconcilingStrategy;
import org.asnlab.asndt.internal.ui.text.asn.IProblemRequestorExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AsnCompositeReconcilingStrategy
extends CompositeReconcilingStrategy {
    private ITextEditor fEditor;
    private AsnReconcilingStrategy fAsnStrategy;

    public AsnCompositeReconcilingStrategy(ITextEditor editor, String documentPartitioning) {
        this.fEditor = editor;
        this.fAsnStrategy = new AsnReconcilingStrategy(editor);
        this.setReconcilingStrategies(new IReconcilingStrategy[]{this.fAsnStrategy});
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel m;
        IDocumentProvider p = this.fEditor.getDocumentProvider();
        if (p == null) {
            p = AsnPlugin.getDefault().getCompilationUnitDocumentProvider();
        }
        if ((m = p.getAnnotationModel((Object)this.fEditor.getEditorInput())) instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)m;
        }
        return null;
    }

    @Override
    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(dirtyRegion, subRegion);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(dirtyRegion, subRegion);
        }
    }

    @Override
    public void reconcile(IRegion partition) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(partition);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(partition);
        }
    }

    public void notifyListeners(boolean notify) {
        this.fAsnStrategy.notifyListeners(notify);
    }

    @Override
    public void initialReconcile() {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.initialReconcile();
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.initialReconcile();
        }
    }

    public void aboutToBeReconciled() {
        this.fAsnStrategy.aboutToBeReconciled();
    }
}

