/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICodeAssist;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.WorkingCopyManager;
import org.asnlab.asndt.internal.ui.text.AsnWordFinder;
import org.asnlab.asndt.internal.ui.text.HTMLTextPresenter;
import org.asnlab.asndt.internal.ui.text.asn.hover.AsnHoverMessages;
import org.asnlab.asndt.ui.text.asn.hover.IAsnEditorTextHover;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.framework.Bundle;

public abstract class AbstractAsnEditorTextHover
implements IAsnEditorTextHover,
ITextHoverExtension {
    private static String fgStyleSheet;
    private IEditorPart fEditor;
    private IBindingService fBindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);

    @Override
    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            WorkingCopyManager manager = AsnPlugin.getDefault().getWorkingCopyManager();
            return manager.getWorkingCopy(input, false);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return AsnWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion.getLength() == 0) {
            return null;
        }
        ICodeAssist resolve = this.getCodeAssist();
        if (resolve != null) {
            IAsnElement[] result;
            block7: {
                block6: {
                    try {
                        result = resolve.codeSelect(hoverRegion.getOffset());
                        if (result != null) break block6;
                        return null;
                    }
                    catch (AsnModelException asnModelException) {
                        return null;
                    }
                }
                int nResults = result.length;
                if (nResults != 0) break block7;
                return null;
            }
            return this.getHoverInfo(result);
        }
        return null;
    }

    protected String getHoverInfo(IAsnElement[] asnElements) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AbstractAsnEditorTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    protected String getTooltipAffordanceString() {
        if (this.fBindingService == null || !AsnPlugin.getDefault().getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return null;
        }
        String keySequence = this.fBindingService.getBestActiveBindingFormattedFor("org.asnlab.asndt.ui.edit.text.asn.show.asndoc");
        if (keySequence == null) {
            return null;
        }
        return Messages.format(AsnHoverMessages.AsnTextHover_makeStickyHint, keySequence == null ? "" : keySequence);
    }

    protected static String getStyleSheet() {
        Bundle bundle;
        URL styleSheetURL;
        if (fgStyleSheet == null && (styleSheetURL = (bundle = Platform.getBundle((String)AsnPlugin.getPluginId())).getEntry("/HoverStyleSheet.css")) != null) {
            try {
                styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
                BufferedReader reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                fgStyleSheet = buffer.toString();
            }
            catch (IOException ex) {
                AsnPlugin.log(ex);
                fgStyleSheet = "";
            }
        }
        return fgStyleSheet;
    }
}

